/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.util.Arrays;
import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.EconomyHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.teleport.TimedTeleport;
import net.william278.huskhomes.teleport.Username;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class TeleportBuilder {
    private final HuskHomes plugin;
    private OnlineUser executor;
    private Teleportable teleporter;
    private Target target;
    private boolean updateLastPosition = true;
    private Teleport.Type type = Teleport.Type.TELEPORT;
    private List<TransactionResolver.Action> actions = List.of();

    protected TeleportBuilder(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public Teleport toTeleport() throws TeleportationException {
        this.validateTeleport();
        return new Teleport(this.executor, this.teleporter, this.target, this.type, this.updateLastPosition, this.actions, this.plugin);
    }

    @NotNull
    public TimedTeleport toTimedTeleport() throws IllegalStateException {
        this.validateTeleport();
        Teleportable teleportable = this.teleporter;
        if (!(teleportable instanceof OnlineUser)) {
            throw new IllegalStateException("Teleporter must be an OnlineUser for timed teleportation");
        }
        OnlineUser onlineTeleporter = (OnlineUser)teleportable;
        return new TimedTeleport(this.executor, onlineTeleporter, this.target, this.type, this.plugin.getSettings().getTeleportWarmupTime(), this.updateLastPosition, this.actions, this.plugin);
    }

    private void validateTeleport() throws TeleportationException {
        if (this.teleporter == null) {
            throw new TeleportationException(TeleportationException.Type.TELEPORTER_NOT_FOUND, this.plugin);
        }
        if (this.executor == null) {
            OnlineUser onlineUser;
            Teleportable teleportable = this.teleporter;
            this.executor = teleportable instanceof OnlineUser ? (onlineUser = (OnlineUser)teleportable) : ((Username)this.teleporter).findLocally(this.plugin).orElseThrow(() -> new TeleportationException(TeleportationException.Type.TELEPORTER_NOT_FOUND, this.plugin));
        }
        if (this.target == null) {
            throw new TeleportationException(TeleportationException.Type.TARGET_NOT_FOUND, this.plugin);
        }
    }

    @NotNull
    public TeleportBuilder executor(@NotNull OnlineUser executor) {
        this.executor = executor;
        return this;
    }

    @NotNull
    public TeleportBuilder teleporter(@NotNull Teleportable teleporter) {
        this.teleporter = teleporter;
        return this;
    }

    @NotNull
    public TeleportBuilder teleporter(@NotNull String teleporter) {
        this.teleporter = Teleportable.username(teleporter);
        return this;
    }

    @NotNull
    public TeleportBuilder target(@NotNull Target target) {
        this.target = target;
        return this;
    }

    @NotNull
    public TeleportBuilder target(@NotNull String target) {
        this.target = Target.username(target);
        return this;
    }

    @NotNull
    public TeleportBuilder updateLastPosition(boolean updateLastPosition) {
        this.updateLastPosition = updateLastPosition;
        return this;
    }

    @Deprecated(since="4.4", forRemoval=true)
    @NotNull
    public TeleportBuilder economyActions(EconomyHook.Action ... economyActions) {
        this.actions = Arrays.stream(economyActions).map(EconomyHook.Action::getTransactionAction).toList();
        return this;
    }

    @NotNull
    public TeleportBuilder actions(TransactionResolver.Action ... actions) {
        this.actions = List.of(actions);
        return this;
    }

    @NotNull
    public TeleportBuilder type(@NotNull Teleport.Type type) {
        this.type = type;
        return this;
    }
}

