/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.teleport;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.event.ITeleportEvent;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.desertwell.util.ThrowingConsumer;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.teleport.Username;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class Teleport {
    protected final HuskHomes plugin;
    protected final OnlineUser executor;
    protected final Teleportable teleporter;
    protected final Target target;
    protected final Type type;
    protected final List<TransactionResolver.Action> actions;
    private final boolean async;
    protected final boolean updateLastPosition;

    protected Teleport(@NotNull OnlineUser executor, @NotNull Teleportable teleporter, @NotNull Target target, @NotNull Type type, boolean updateLastPosition, @NotNull List<TransactionResolver.Action> actions, @NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.executor = executor;
        this.teleporter = teleporter;
        this.target = target;
        this.type = type;
        this.actions = actions;
        this.async = plugin.getSettings().doAsynchronousTeleports();
        this.updateLastPosition = updateLastPosition && plugin.getCommand(BackCommand.class).map(command -> executor.hasPermission(command.getPermission(new String[0])) && executor.hasPermission(command.getPermission("previous"))).orElse(false) != false;
    }

    @NotNull
    public static TeleportBuilder builder(@NotNull HuskHomes plugin) {
        return new TeleportBuilder(plugin);
    }

    public void execute() throws TeleportationException {
        Optional<OnlineUser> localTeleporter = this.resolveLocalTeleporter();
        this.validateTransactions();
        if (localTeleporter.isEmpty()) {
            Username teleporter = (Username)this.teleporter;
            if (!this.plugin.getSettings().doCrossServer()) {
                throw new TeleportationException(TeleportationException.Type.TELEPORTER_NOT_FOUND, this.plugin);
            }
            this.fireEvent(event -> {
                this.performTransactions();
                Target patt3522$temp = this.target;
                if (patt3522$temp instanceof Username) {
                    Username username = (Username)patt3522$temp;
                    Message.builder().type(Message.Type.TELEPORT_TO_NETWORKED_USER).target(teleporter.name()).payload(Payload.withString(username.name())).build().send(this.plugin.getMessenger(), this.executor);
                    return;
                }
                Message.builder().type(Message.Type.TELEPORT_TO_POSITION).target(teleporter.name()).payload(Payload.withPosition((Position)this.target)).build().send(this.plugin.getMessenger(), this.executor);
            });
            return;
        }
        OnlineUser teleporter = localTeleporter.get();
        Target target = this.target;
        if (target instanceof Username) {
            Optional<OnlineUser> localTarget;
            Username username = (Username)target;
            Optional<OnlineUser> optional = localTarget = username.name().equals("@s") ? Optional.of(this.executor) : username.findLocally(this.plugin);
            if (localTarget.isPresent()) {
                this.fireEvent(event -> {
                    this.performTransactions();
                    if (this.updateLastPosition) {
                        this.plugin.getDatabase().setLastPosition(teleporter, teleporter.getPosition());
                    }
                    try {
                        teleporter.teleportLocally(((OnlineUser)localTarget.get()).getPosition(), this.async);
                    }
                    catch (TeleportationException e) {
                        e.displayMessage(teleporter, new String[0]);
                        return;
                    }
                    this.displayTeleportingComplete(teleporter);
                });
                return;
            }
            if (this.plugin.getSettings().doCrossServer()) {
                this.fireEvent(event -> {
                    this.performTransactions();
                    Message.builder().type(Message.Type.TELEPORT_TO_NETWORKED_POSITION).target(username.name()).build().send(this.plugin.getMessenger(), this.executor);
                });
                return;
            }
            throw new TeleportationException(TeleportationException.Type.TARGET_NOT_FOUND, this.plugin);
        }
        this.fireEvent(event -> {
            this.performTransactions();
            if (this.updateLastPosition) {
                this.plugin.getDatabase().setLastPosition(teleporter, teleporter.getPosition());
            }
            Position target = (Position)this.target;
            if (!this.plugin.getSettings().doCrossServer() || target.getServer().equals(this.plugin.getServerName())) {
                try {
                    teleporter.teleportLocally(target, this.async);
                }
                catch (TeleportationException e) {
                    e.displayMessage(teleporter, new String[0]);
                    return;
                }
                this.displayTeleportingComplete(teleporter);
                return;
            }
            this.plugin.getDatabase().setCurrentTeleport(teleporter, this);
            this.plugin.getMessenger().changeServer(teleporter, target.getServer());
        });
    }

    @NotNull
    private Optional<OnlineUser> resolveLocalTeleporter() throws TeleportationException {
        Teleportable teleportable = this.teleporter;
        if (teleportable instanceof Username) {
            Username username = (Username)teleportable;
            return username.findLocally(this.plugin);
        }
        return Optional.of((OnlineUser)this.teleporter);
    }

    public void displayTeleportingComplete(@NotNull OnlineUser teleporter) {
        this.plugin.getLocales().getLocale("teleporting_complete").ifPresent(teleporter::sendMessage);
        this.plugin.getSettings().getSoundEffect(Settings.SoundEffectAction.TELEPORTATION_COMPLETE).ifPresent(teleporter::playSound);
    }

    private void fireEvent(@NotNull ThrowingConsumer<ITeleportEvent> afterFired) {
        this.plugin.fireEvent(this.plugin.getTeleportEvent(this), afterFired);
    }

    protected void validateTransactions() throws TeleportationException {
        if (this.actions.stream().map(action -> this.plugin.validateTransaction(this.executor, (TransactionResolver.Action)((Object)action))).anyMatch(result -> result == false)) {
            throw new TeleportationException(TeleportationException.Type.TRANSACTION_FAILED, this.plugin);
        }
    }

    private void performTransactions() {
        this.actions.forEach(action -> this.plugin.performTransaction(this.executor, (TransactionResolver.Action)((Object)action)));
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public Teleportable getTeleporter() {
        return this.teleporter;
    }

    @NotNull
    public Target getTarget() {
        return this.target;
    }

    public static enum Type {
        TELEPORT(0),
        RESPAWN(1),
        BACK(2);

        private final int typeId;

        private Type(int typeId) {
            this.typeId = typeId;
        }

        public static Optional<Type> getTeleportType(int typeId) {
            return Arrays.stream(Type.values()).filter(type -> type.getTypeId() == typeId).findFirst();
        }

        public int getTypeId() {
            return this.typeId;
        }
    }
}

