/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.random;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportEngine;

public final class NormalDistributionEngine
extends RandomTeleportEngine {
    private final int radius;
    private final int spawnRadius;
    private final float mean;
    private final float standardDeviation;

    public NormalDistributionEngine(@NotNull HuskHomes plugin) {
        super(plugin, "Normal Distribution");
        this.radius = plugin.getSettings().getRtpRadius();
        this.spawnRadius = plugin.getSettings().getRtpSpawnRadius();
        this.mean = plugin.getSettings().getRtpDistributionMean();
        this.standardDeviation = plugin.getSettings().getRtpDistributionStandardDeviation();
    }

    @NotNull
    public static Location generateLocation(@NotNull Location origin, float mean, float standardDeviation, float spawnRadius, float maxRadius) {
        float radius = NormalDistributionEngine.getDistributedRadius(mean, standardDeviation, spawnRadius, maxRadius);
        float angle = NormalDistributionEngine.getRandomAngle();
        float z = (float)((double)radius * Math.cos(angle));
        float x = (float)((double)radius * Math.sin(angle));
        return Location.at((float)Math.round(origin.getX()) + x, 128.0, (float)Math.round(origin.getZ()) + z, origin.getWorld());
    }

    private CompletableFuture<Optional<Location>> generateSafeLocation(@NotNull World world) {
        return this.plugin.findSafeGroundLocation(NormalDistributionEngine.generateLocation(this.getCenterPoint(world), this.mean, this.standardDeviation, this.spawnRadius, this.radius));
    }

    private static float getDistributedRadius(float mean, float standardDeviation, float spawnRadius, float maxRadius) {
        double value = (new Random().nextGaussian() * (double)mean + (double)standardDeviation) * (double)maxRadius;
        if (value < (double)spawnRadius || value > (double)maxRadius) {
            return NormalDistributionEngine.getDistributedRadius(mean, standardDeviation, spawnRadius, maxRadius);
        }
        return (float)value;
    }

    private static float getRandomAngle() {
        return (float)(Math.random() * 360.0);
    }

    @Override
    public CompletableFuture<Optional<Position>> getRandomPosition(@NotNull World world, @NotNull String[] args) {
        return this.plugin.supplyAsync(() -> {
            Optional<Location> location = this.generateSafeLocation(world).join();
            int attempts = 0;
            while (location.isEmpty()) {
                location = this.generateSafeLocation(world).join();
                if ((long)attempts >= this.maxAttempts) {
                    return Optional.empty();
                }
                ++attempts;
            }
            return location.map(resolved -> Position.at(resolved, this.plugin.getServerName()));
        });
    }
}

