/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import java.util.Optional;
import java.util.UUID;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;

public class World {
    private String name;
    private UUID uuid;
    @Nullable
    private Environment environment;

    private World(@NotNull String name, @NotNull UUID uuid, @Nullable Environment environment) {
        this.setName(name);
        this.setUuid(uuid);
        this.setEnvironment(environment);
    }

    public World() {
    }

    @NotNull
    public static World from(@NotNull String name, @NotNull UUID uuid, @NotNull Environment environment) {
        return new World(name, uuid, environment);
    }

    @NotNull
    public static World from(@NotNull String name, @NotNull UUID uuid) {
        return new World(name, uuid, null);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(@NotNull UUID uuid) {
        this.uuid = uuid;
    }

    @NotNull
    public Environment getEnvironment() {
        return Optional.ofNullable(this.environment).orElse(Environment.OVERWORLD);
    }

    public void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    public boolean equals(@NotNull Object obj) {
        if (obj instanceof World) {
            World world = (World)obj;
            return world.getUuid().equals(this.getUuid());
        }
        return super.equals(obj);
    }

    public static enum Environment {
        OVERWORLD,
        NETHER,
        THE_END,
        CUSTOM;

    }
}

