/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import com.google.common.reflect.TypeToken;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.gson.Gson;

public class PositionMeta {
    private String name;
    private String description;
    private Map<String, String> tags;
    private Instant creationTime;

    private PositionMeta(@NotNull String name, @NotNull String description, @NotNull Instant creationTime, @Nullable String serializedTags) {
        this.setName(name);
        this.setDescription(description);
        this.setCreationTime(creationTime);
        this.setTags(PositionMeta.deserializeTags(serializedTags));
    }

    @NotNull
    public static PositionMeta from(@NotNull String name, @NotNull String description, @NotNull Instant creationTime, @Nullable String serializedTags) {
        return new PositionMeta(name, description, creationTime, serializedTags);
    }

    @NotNull
    public static PositionMeta create(@NotNull String name, @NotNull String description) {
        return PositionMeta.from(name, description, Instant.now(), "");
    }

    @NotNull
    private static Map<String, String> deserializeTags(@Nullable String serializedTags) {
        try {
            if (serializedTags == null || serializedTags.isBlank()) {
                return new HashMap<String, String>();
            }
            return (Map)new Gson().fromJson(serializedTags, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    @Nullable
    public String getSerializedTags() {
        try {
            if (this.getTags().isEmpty()) {
                return null;
            }
            return new Gson().toJson(this.getTags());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @NotNull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }
}

