/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;

public class Position
extends Location
implements Target {
    @Expose
    private String server;

    protected Position(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server) {
        super(x, y, z, yaw, pitch, world);
        this.setServer(server);
    }

    protected Position(@NotNull Location location, @NotNull String server) {
        super(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), location.getWorld());
        this.setServer(server);
    }

    private Position() {
    }

    @NotNull
    public static Position at(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server) {
        return new Position(x, y, z, yaw, pitch, world, server);
    }

    @NotNull
    public static Position at(double x, double y, double z, @NotNull World world, @NotNull String server) {
        return Position.at(x, y, z, 0.0f, 0.0f, world, server);
    }

    @NotNull
    public static Position at(@NotNull Location location, @NotNull String server) {
        return new Position(location, server);
    }

    @Override
    public void update(@NotNull Position newPosition) {
        super.update(newPosition);
        this.setServer(newPosition.getServer());
    }

    @NotNull
    public String getServer() {
        return this.server;
    }

    public void setServer(@NotNull String server) {
        this.server = server;
    }

    public String toString() {
        return "x: " + (int)this.getX() + ", y: " + (int)this.getY() + ", z: " + (int)this.getZ() + " (" + this.getWorld().getName() + " / " + this.getServer() + ")";
    }
}

