/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;

public class Location {
    @Expose
    private double x;
    @Expose
    private double y;
    @Expose
    private double z;
    @Expose
    private float yaw;
    @Expose
    private float pitch;
    @Expose
    private World world;

    protected Location(double x, double y, double z, float yaw, float pitch, @NotNull World world) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setWorld(world);
    }

    public Location() {
    }

    @NotNull
    public static Location at(double x, double y, double z, float yaw, float pitch, @NotNull World world) {
        return new Location(x, y, z, yaw, pitch, world);
    }

    @NotNull
    public static Location at(double x, double y, double z, @NotNull World world) {
        return Location.at(x, y, z, 0.0f, 0.0f, world);
    }

    public void update(@NotNull Position position) {
        this.setX(position.getX());
        this.setY(position.getY());
        this.setZ(position.getZ());
        this.setYaw(position.getYaw());
        this.setPitch(position.getPitch());
        this.setWorld(position.getWorld());
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }
}

