/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.position;

import java.util.UUID;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.user.User;

public class Home
extends SavedPosition {
    public static final String IDENTIFIER_DELIMITER = ".";
    private final User owner;
    private boolean isPublic;

    private Home(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server, @NotNull PositionMeta positionMeta, @NotNull UUID uuid, @NotNull User owner, boolean isPublic) {
        super(x, y, z, yaw, pitch, world, server, positionMeta, uuid);
        this.owner = owner;
        this.setPublic(isPublic);
    }

    private Home(@NotNull Position position, @NotNull PositionMeta meta, @NotNull User owner) {
        super(position, meta);
        this.owner = owner;
        this.setPublic(false);
    }

    @NotNull
    public static Home from(double x, double y, double z, float yaw, float pitch, @NotNull World world, @NotNull String server, @NotNull PositionMeta positionMeta, @NotNull UUID uuid, @NotNull User owner, boolean isPublic) {
        return new Home(x, y, z, yaw, pitch, world, server, positionMeta, uuid, owner, isPublic);
    }

    @NotNull
    public static Home from(@NotNull Position position, @NotNull PositionMeta meta, @NotNull User owner) {
        return new Home(position, meta, owner);
    }

    @NotNull
    public User getOwner() {
        return this.owner;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    @NotNull
    public String getSafeIdentifier() {
        return this.getOwner().getUsername() + IDENTIFIER_DELIMITER + super.getSafeIdentifier();
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.getOwner().getUsername() + IDENTIFIER_DELIMITER + super.getIdentifier();
    }
}

