/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.user.OnlineUser;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisBroker
extends PluginMessageBroker {
    private JedisPool jedisPool;

    public RedisBroker(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void initialize() throws IllegalStateException {
        super.initialize();
        String password = this.plugin.getSettings().getRedisPassword();
        String host = this.plugin.getSettings().getRedisHost();
        int port = this.plugin.getSettings().getRedisPort();
        boolean useSSL = this.plugin.getSettings().useRedisSsl();
        this.jedisPool = password.isEmpty() ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, 0, useSSL) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, 0, password, useSSL);
        new Thread(this.getSubscriber(), this.plugin.getKey("redis_subscriber").toString()).start();
        this.plugin.log(Level.INFO, "Initialized Redis connection pool", new Throwable[0]);
    }

    @NotNull
    private Runnable getSubscriber() {
        return () -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.subscribe(new JedisPubSub(){

                    public void onMessage(@NotNull String channel, @NotNull String encodedMessage) {
                        Message message;
                        if (!channel.equals(RedisBroker.this.getSubChannelId())) {
                            return;
                        }
                        try {
                            message = RedisBroker.this.plugin.getGson().fromJson(encodedMessage, Message.class);
                        }
                        catch (Exception e) {
                            RedisBroker.this.plugin.log(Level.WARNING, "Failed to decode message from Redis: " + e.getMessage(), new Throwable[0]);
                            return;
                        }
                        if (message.getScope() == Message.Scope.PLAYER) {
                            RedisBroker.this.plugin.getOnlineUsers().stream().filter(online -> message.getTarget().equals("ALL") || online.getUsername().equals(message.getTarget())).forEach(receiver -> RedisBroker.this.handle((OnlineUser)receiver, message));
                            return;
                        }
                        if (message.getTarget().equals(RedisBroker.this.plugin.getServerName()) || message.getTarget().equals("ALL")) {
                            RedisBroker.this.plugin.getOnlineUsers().stream().findAny().ifPresent(receiver -> RedisBroker.this.handle((OnlineUser)receiver, message));
                        }
                    }
                }, new String[]{this.getSubChannelId()});
            }
        };
    }

    @Override
    protected void send(@NotNull Message message, @NotNull OnlineUser sender) {
        this.plugin.runAsync(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.publish(this.getSubChannelId(), this.plugin.getGson().toJson(message));
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
    }
}

