/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.libraries.gson.annotations.SerializedName;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.TeleportRequest;

public class Payload {
    @Expose
    @Nullable
    private Position position;
    @Expose
    @SerializedName(value="teleport_request")
    @Nullable
    private TeleportRequest teleportRequest;
    @Expose
    @Nullable
    private String string;
    @Expose
    @SerializedName(value="string_list")
    @Nullable
    private List<String> stringList;

    @NotNull
    public static Payload empty() {
        return new Payload();
    }

    @NotNull
    public static Payload withPosition(@NotNull Position position) {
        Payload payload = new Payload();
        payload.position = position;
        return payload;
    }

    @NotNull
    public static Payload withTeleportRequest(@NotNull TeleportRequest teleportRequest) {
        Payload payload = new Payload();
        payload.teleportRequest = teleportRequest;
        return payload;
    }

    @NotNull
    public static Payload withString(@NotNull String target) {
        Payload payload = new Payload();
        payload.string = target;
        return payload;
    }

    @NotNull
    public static Payload withStringList(@NotNull List<String> target) {
        Payload payload = new Payload();
        payload.stringList = target;
        return payload;
    }

    private Payload() {
    }

    public Optional<Position> getPosition() {
        return Optional.ofNullable(this.position);
    }

    public Optional<TeleportRequest> getTeleportRequest() {
        return Optional.ofNullable(this.teleportRequest);
    }

    public Optional<String> getString() {
        return Optional.ofNullable(this.string);
    }

    public Optional<List<String>> getStringList() {
        return Optional.ofNullable(this.stringList);
    }
}

