/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.UUID;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.gson.annotations.Expose;
import net.william278.huskhomes.libraries.gson.annotations.SerializedName;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.user.OnlineUser;

public class Message {
    public static final String TARGET_ALL = "ALL";
    @Expose
    private UUID id;
    @Expose
    private Type type;
    @Expose
    private Scope scope;
    @Expose
    private String target;
    @Expose
    private Payload payload;
    @Expose
    private String sender;
    @Expose
    @SerializedName(value="source_server")
    private String sourceServer;

    private Message(@NotNull Type type, @NotNull Scope scope, @NotNull String target, @NotNull Payload payload) {
        this.type = type;
        this.scope = scope;
        this.target = target;
        this.payload = payload;
        this.id = UUID.randomUUID();
    }

    private Message() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void send(@NotNull Broker broker, @NotNull OnlineUser sender) {
        this.sender = sender.getUsername();
        this.sourceServer = broker.getServer();
        broker.send(this, sender);
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    @NotNull
    public String getTarget() {
        return this.target;
    }

    @NotNull
    public Payload getPayload() {
        return this.payload;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public String getSourceServer() {
        return this.sourceServer;
    }

    @NotNull
    public UUID getUuid() {
        return this.id;
    }

    public static enum Type {
        TELEPORT_TO_POSITION,
        TELEPORT_TO_NETWORKED_POSITION,
        TELEPORT_REQUEST,
        TELEPORT_TO_NETWORKED_USER,
        TELEPORT_REQUEST_RESPONSE,
        REQUEST_PLAYER_LIST,
        PLAYER_LIST,
        UPDATE_HOME,
        UPDATE_WARP,
        UPDATE_CACHES;

    }

    public static enum Scope {
        SERVER("Forward"),
        PLAYER("ForwardToPlayer");

        private final String pluginMessageChannel;

        private Scope(String pluginMessageChannel) {
            this.pluginMessageChannel = pluginMessageChannel;
        }

        @NotNull
        public String getPluginMessageChannel() {
            return this.pluginMessageChannel;
        }
    }

    public static class Builder {
        private Type type;
        private Scope scope = Scope.PLAYER;
        private Payload payload = Payload.empty();
        private String target;

        private Builder() {
        }

        @NotNull
        public Builder type(@NotNull Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder scope(@NotNull Scope scope) {
            this.scope = scope;
            return this;
        }

        @NotNull
        public Builder payload(@NotNull Payload payload) {
            this.payload = payload;
            return this;
        }

        @NotNull
        public Builder target(@NotNull String target) {
            this.target = target;
            return this;
        }

        @NotNull
        public Message build() {
            if (this.type == null) {
                throw new IllegalStateException("Message type must be set");
            }
            if (this.target == null) {
                throw new IllegalStateException("Message target must be set");
            }
            return new Message(this.type, this.scope, this.target, this.payload);
        }
    }
}

