/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.adventure.key.InvalidKeyException;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;

public abstract class Broker {
    protected final HuskHomes plugin;

    protected Broker(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    protected void handle(@NotNull OnlineUser receiver, @NotNull Message message) {
        if (message.getSourceServer().equals(this.getServer())) {
            return;
        }
        switch (message.getType()) {
            case TELEPORT_TO_POSITION: {
                message.getPayload().getPosition().ifPresent(position -> {
                    try {
                        Teleport.builder(this.plugin).teleporter(receiver).target((Target)position).toTeleport().execute();
                    }
                    catch (TeleportationException e) {
                        e.displayMessage(this.plugin.getConsole(), new String[0]);
                    }
                });
                break;
            }
            case TELEPORT_TO_NETWORKED_POSITION: {
                Message.builder().type(Message.Type.TELEPORT_TO_POSITION).target(message.getSender()).payload(Payload.withPosition(receiver.getPosition())).build().send(this, receiver);
                break;
            }
            case TELEPORT_TO_NETWORKED_USER: {
                message.getPayload().getString().ifPresent(target -> Message.builder().type(Message.Type.TELEPORT_TO_NETWORKED_POSITION).target((String)target).build().send(this, receiver));
                break;
            }
            case TELEPORT_REQUEST: {
                message.getPayload().getTeleportRequest().ifPresent(teleportRequest -> this.plugin.getManager().requests().sendLocalTeleportRequest((TeleportRequest)teleportRequest, receiver));
                break;
            }
            case TELEPORT_REQUEST_RESPONSE: {
                message.getPayload().getTeleportRequest().ifPresent(teleportRequest -> this.plugin.getManager().requests().handleLocalRequestResponse(receiver, (TeleportRequest)teleportRequest));
                break;
            }
            case REQUEST_PLAYER_LIST: {
                Message.builder().type(Message.Type.PLAYER_LIST).scope(Message.Scope.SERVER).target(message.getSourceServer()).payload(Payload.withStringList(this.plugin.getLocalPlayerList())).build().send(this, receiver);
                break;
            }
            case PLAYER_LIST: {
                message.getPayload().getStringList().ifPresent(players -> this.plugin.setPlayerList(message.getSourceServer(), (List<String>)players));
                break;
            }
            case UPDATE_HOME: {
                message.getPayload().getString().map(UUID::fromString).ifPresent(homeId -> {
                    Optional<Home> optionalHome = this.plugin.getDatabase().getHome((UUID)homeId);
                    if (optionalHome.isPresent()) {
                        this.plugin.getManager().homes().cacheHome(optionalHome.get(), false);
                    } else {
                        this.plugin.getManager().homes().unCacheHome((UUID)homeId, false);
                    }
                });
                break;
            }
            case UPDATE_WARP: {
                message.getPayload().getString().map(UUID::fromString).ifPresent(warpId -> {
                    Optional<Warp> optionalWarp = this.plugin.getDatabase().getWarp((UUID)warpId);
                    if (optionalWarp.isPresent()) {
                        this.plugin.getManager().warps().cacheWarp(optionalWarp.get(), false);
                    } else {
                        this.plugin.getManager().warps().unCacheWarp((UUID)warpId, false);
                    }
                });
                break;
            }
            case UPDATE_CACHES: {
                this.plugin.getManager().homes().updatePublicHomeCache();
                this.plugin.getManager().warps().updateWarpCache();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + message.getType());
            }
        }
    }

    public abstract void initialize() throws IllegalStateException;

    protected abstract void send(@NotNull Message var1, @NotNull OnlineUser var2);

    public abstract void changeServer(@NotNull OnlineUser var1, @NotNull String var2);

    public abstract void close();

    @NotNull
    protected String getSubChannelId() {
        String version = String.format("%s.%s", this.plugin.getVersion().getMajor(), this.plugin.getVersion().getMinor());
        try {
            return this.plugin.getKey(this.plugin.getSettings().getClusterId().toLowerCase(Locale.ENGLISH), version).asString();
        }
        catch (InvalidKeyException e) {
            this.plugin.log(Level.SEVERE, "Cluster ID specified in config contains invalid characters", new Throwable[0]);
            return this.plugin.getKey("main", version).asString();
        }
    }

    @NotNull
    protected String getServer() {
        return this.plugin.getServerName();
    }

    public static enum Type {
        PLUGIN_MESSAGE("Plugin Messages"),
        REDIS("Redis");

        @NotNull
        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

