/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.manager;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class WarpsManager {
    private final HuskHomes plugin;
    private final ConcurrentLinkedQueue<Warp> warps;

    protected WarpsManager(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.warps = new ConcurrentLinkedQueue<Warp>(plugin.getDatabase().getWarps());
    }

    public void cacheWarp(@NotNull Warp warp, boolean propagate) {
        this.warps.remove(warp);
        this.warps.add(warp);
        this.plugin.getMapHook().ifPresent(hook -> hook.updateWarp(warp));
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(warp.getUuid());
        }
    }

    public void unCacheWarp(@NotNull UUID warpId, boolean propagate) {
        this.warps.removeIf(warp -> {
            if (warp.getUuid().equals(warpId)) {
                this.plugin.getMapHook().ifPresent(hook -> hook.removeWarp((Warp)warp));
                return true;
            }
            return false;
        });
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(warpId);
        }
    }

    private void propagateCacheUpdate(@NotNull UUID warpId) {
        if (this.plugin.getSettings().doCrossServer()) {
            this.plugin.getOnlineUsers().stream().findAny().ifPresent(user -> Message.builder().type(Message.Type.UPDATE_WARP).scope(Message.Scope.SERVER).target("ALL").payload(Payload.withString(warpId.toString())).build().send(this.plugin.getMessenger(), (OnlineUser)user));
        }
    }

    public void updateWarpCache() {
        this.plugin.getDatabase().getWarps().forEach(warp -> this.cacheWarp((Warp)warp, false));
    }

    @NotNull
    public List<String> getWarps() {
        return this.warps.stream().map(SavedPosition::getName).toList();
    }

    @NotNull
    public List<String> getUsableWarps(@NotNull CommandUser user) {
        if (!this.plugin.getSettings().doPermissionRestrictWarps() || user.hasPermission(Warp.getWildcardPermission())) {
            return this.getWarps();
        }
        return this.warps.stream().filter(warp -> user.hasPermission(warp.getPermission())).map(SavedPosition::getName).toList();
    }

    @NotNull
    public Warp createWarp(@NotNull String name, @NotNull Position position, boolean overwrite) throws ValidationException {
        Optional<Warp> existingWarp = this.plugin.getDatabase().getWarp(name);
        if (existingWarp.isPresent() && !overwrite) {
            throw new ValidationException(ValidationException.Type.NAME_TAKEN);
        }
        this.plugin.getValidator().validateName(name);
        Warp warp = existingWarp.map(existing -> {
            existing.getMeta().setName(name);
            existing.update(position);
            return existing;
        }).orElse(Warp.from(position, PositionMeta.create(name, "")));
        this.plugin.getDatabase().saveWarp(warp);
        this.cacheWarp(warp, true);
        return warp;
    }

    @NotNull
    public Warp createWarp(@NotNull String name, @NotNull Position position) throws ValidationException {
        return this.createWarp(name, position, this.plugin.getSettings().doOverwriteExistingHomesWarps());
    }

    public void deleteWarp(@NotNull String name) throws ValidationException {
        Optional<Warp> warp = this.plugin.getDatabase().getWarp(name);
        if (warp.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.deleteWarp(warp.get());
    }

    public void deleteWarp(@NotNull Warp warp) {
        this.plugin.getDatabase().deleteWarp(warp.getUuid());
        this.unCacheWarp(warp.getUuid(), true);
    }

    public int deleteAllWarps() {
        int deleted = this.plugin.getDatabase().deleteAllWarps();
        this.warps.clear();
        this.plugin.getMapHook().ifPresent(MapHook::clearWarps);
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public int deleteAllWarps(@NotNull String worldName, @NotNull String serverName) {
        int deleted = this.plugin.getDatabase().deleteAllWarps(worldName, serverName);
        this.warps.removeIf(warp -> warp.getServer().equals(serverName) && warp.getWorld().getName().equals(worldName));
        if (this.plugin.getSettings().doCrossServer() && this.plugin.getServerName().equals(serverName)) {
            this.plugin.getMapHook().ifPresent(hook -> hook.clearWarps(worldName));
        }
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public void setWarpPosition(@NotNull String name, @NotNull Position position) throws ValidationException {
        Optional<Warp> optionalWarp = this.plugin.getDatabase().getWarp(name);
        if (optionalWarp.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setWarpPosition(optionalWarp.get(), position);
    }

    public void setWarpPosition(@NotNull Warp warp, @NotNull Position position) {
        warp.update(position);
        this.plugin.getDatabase().saveWarp(warp);
        this.cacheWarp(warp, true);
    }

    public void setWarpName(@NotNull String name, @NotNull String newName) throws ValidationException {
        Optional<Warp> optionalWarp = this.plugin.getDatabase().getWarp(name);
        if (optionalWarp.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setWarpName(optionalWarp.get(), newName);
    }

    public void setWarpName(@NotNull Warp warp, @NotNull String newName) throws ValidationException {
        this.plugin.getValidator().validateName(newName);
        warp.getMeta().setName(newName);
        this.plugin.getDatabase().saveWarp(warp);
        this.cacheWarp(warp, true);
    }

    public void setWarpDescription(@NotNull String name, @NotNull String description) throws ValidationException {
        Optional<Warp> optionalWarp = this.plugin.getDatabase().getWarp(name);
        if (optionalWarp.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setWarpDescription(optionalWarp.get(), description);
    }

    public void setWarpDescription(@NotNull Warp warp, @NotNull String description) {
        this.plugin.getValidator().validateDescription(description);
        warp.getMeta().setDescription(description);
        this.plugin.getDatabase().saveWarp(warp);
        this.cacheWarp(warp, true);
    }

    public void setWarpMetaTags(@NotNull String name, @NotNull Map<String, String> tags) throws ValidationException {
        Optional<Warp> optionalWarp = this.plugin.getDatabase().getWarp(name);
        if (optionalWarp.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setWarpMetaTags(optionalWarp.get(), tags);
    }

    public void setWarpMetaTags(@NotNull Warp warp, @NotNull Map<String, String> tags) {
        warp.getMeta().setTags(tags);
        this.plugin.getDatabase().saveWarp(warp);
        this.cacheWarp(warp, true);
    }
}

