/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;
import net.william278.huskhomes.util.ValidationException;

public class HomesManager {
    private final HuskHomes plugin;
    private final ConcurrentLinkedQueue<Home> publicHomes;
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<Home>> userHomes;

    protected HomesManager(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
        this.publicHomes = new ConcurrentLinkedQueue<Home>(plugin.getDatabase().getPublicHomes());
        this.userHomes = new ConcurrentHashMap();
        plugin.runAsync(() -> plugin.getOnlineUsers().forEach(this::cacheUserHomes));
    }

    @NotNull
    public Map<String, List<String>> getUserHomes() {
        return this.userHomes.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ConcurrentLinkedQueue)e.getValue()).stream().map(SavedPosition::getName).toList()), HashMap::putAll);
    }

    @NotNull
    public List<String> getUserHomeIdentifiers() {
        return this.userHomes.entrySet().stream().flatMap(e -> ((ConcurrentLinkedQueue)e.getValue()).stream().map(Home::getIdentifier)).toList();
    }

    @NotNull
    public Map<String, List<String>> getPublicHomes() {
        return this.publicHomes.stream().collect(HashMap::new, (m, e) -> m.put(e.getOwner().getUsername(), List.of(e.getName())), HashMap::putAll);
    }

    @NotNull
    public List<String> getPublicHomeIdentifiers() {
        return this.publicHomes.stream().map(Home::getIdentifier).toList();
    }

    public void cacheUserHomes(@NotNull User user) {
        this.userHomes.put(user.getUsername(), new ConcurrentLinkedQueue<Home>(this.plugin.getDatabase().getHomes(user)));
    }

    public void cacheHome(@NotNull Home home, boolean propagate) {
        this.userHomes.computeIfPresent(home.getOwner().getUsername(), (k, v) -> {
            v.remove(home);
            v.add(home);
            return v;
        });
        if (this.publicHomes.remove(home) && !home.isPublic()) {
            this.plugin.getMapHook().ifPresent(hook -> hook.removeHome(home));
        }
        if (home.isPublic()) {
            this.publicHomes.add(home);
            this.plugin.getMapHook().ifPresent(hook -> hook.updateHome(home));
        }
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(home.getUuid());
        }
    }

    public void unCacheHome(@NotNull UUID homeId, boolean propagate) {
        this.userHomes.values().forEach(homes -> homes.removeIf(home -> home.getUuid().equals(homeId)));
        this.publicHomes.removeIf(home -> {
            if (home.getUuid().equals(homeId)) {
                this.plugin.getMapHook().ifPresent(hook -> hook.removeHome((Home)home));
                return true;
            }
            return false;
        });
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        if (propagate) {
            this.propagateCacheUpdate(homeId);
        }
    }

    private void propagateCacheUpdate(@NotNull UUID homeId) {
        if (this.plugin.getSettings().doCrossServer()) {
            this.plugin.getOnlineUsers().stream().findAny().ifPresent(user -> Message.builder().type(Message.Type.UPDATE_HOME).scope(Message.Scope.SERVER).target("ALL").payload(Payload.withString(homeId.toString())).build().send(this.plugin.getMessenger(), (OnlineUser)user));
        }
    }

    public void updatePublicHomeCache() {
        this.plugin.getDatabase().getPublicHomes().forEach(home -> this.cacheHome((Home)home, false));
    }

    public void removeUserHomes(@NotNull User user) {
        this.userHomes.remove(user.getUuid().toString());
    }

    @NotNull
    public Home createHome(@NotNull User owner, @NotNull String name, @NotNull Position position, boolean overwrite, boolean buyAdditionalSlots, boolean ignoreMaxHomes) throws ValidationException {
        Optional<Home> existingHome = this.plugin.getDatabase().getHome(owner, name);
        if (existingHome.isPresent() && !overwrite) {
            throw new ValidationException(ValidationException.Type.NAME_TAKEN);
        }
        this.plugin.getValidator().validateName(name);
        int homes = this.plugin.getDatabase().getHomes(owner).size() + (existingHome.isPresent() ? 0 : 1);
        if (!ignoreMaxHomes && homes > this.getMaxHomes(owner)) {
            throw new ValidationException(ValidationException.Type.REACHED_MAX_HOMES);
        }
        SavedUser savedOwner = this.plugin.getSavedUser(owner).or(() -> this.plugin.getDatabase().getUserData(owner.getUuid())).orElseThrow(() -> new IllegalStateException("User data not found for " + owner.getUuid()));
        if (this.plugin.getSettings().doEconomy() && homes > this.getFreeHomes(owner) && homes > savedOwner.getHomeSlots()) {
            if (!buyAdditionalSlots || this.plugin.getEconomyHook().isEmpty() || !(owner instanceof OnlineUser)) {
                throw new ValidationException(ValidationException.Type.NOT_ENOUGH_HOME_SLOTS);
            }
            OnlineUser online = (OnlineUser)owner;
            if (!this.plugin.validateTransaction(online, TransactionResolver.Action.ADDITIONAL_HOME_SLOT)) {
                throw new ValidationException(ValidationException.Type.TRANSACTION_FAILED);
            }
            this.plugin.performTransaction(online, TransactionResolver.Action.ADDITIONAL_HOME_SLOT);
            this.plugin.editUserData(online, saved -> saved.setHomeSlots(saved.getHomeSlots() + 1));
        }
        Home home = existingHome.map(existing -> {
            existing.getMeta().setName(name);
            existing.update(position);
            return existing;
        }).orElse(Home.from(position, PositionMeta.create(name, ""), owner));
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
        return home;
    }

    public void createHome(@NotNull OnlineUser owner, @NotNull String name, @NotNull Position position) throws ValidationException {
        this.createHome(owner, name, position, this.plugin.getSettings().doOverwriteExistingHomesWarps(), true, false);
    }

    public void deleteHome(@NotNull User owner, @NotNull String name) throws ValidationException {
        Optional<Home> home = this.plugin.getDatabase().getHome(owner, name);
        if (home.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.deleteHome(home.get());
    }

    public void deleteHome(@NotNull Home home) {
        this.plugin.getDatabase().deleteHome(home.getUuid());
        this.unCacheHome(home.getUuid(), true);
    }

    public int deleteAllHomes(@NotNull User owner) {
        int deleted = this.plugin.getDatabase().deleteAllHomes(owner);
        this.userHomes.computeIfPresent(owner.getUsername(), (k, v) -> {
            v.clear();
            return v;
        });
        this.publicHomes.removeIf(h -> h.getOwner().getUuid().equals(owner.getUuid()));
        this.plugin.getMapHook().ifPresent(hook -> hook.clearHomes(owner));
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public int deleteAllHomes(@NotNull String worldName, @NotNull String serverName) {
        int deleted = this.plugin.getDatabase().deleteAllHomes(worldName, serverName);
        this.userHomes.values().forEach(homes -> homes.removeIf(h -> h.getWorld().getName().equals(worldName) && h.getServer().equals(serverName)));
        this.publicHomes.removeIf(h -> h.getWorld().getName().equals(worldName) && h.getServer().equals(serverName));
        if (this.plugin.getSettings().doCrossServer() && serverName.equals(this.plugin.getServerName())) {
            this.plugin.getMapHook().ifPresent(hook -> hook.clearHomes(worldName));
        }
        this.plugin.getCommands().stream().filter(command -> command instanceof ListCommand).map(command -> (ListCommand)command).forEach(ListCommand::invalidateCaches);
        this.plugin.getManager().propagateCacheUpdate();
        return deleted;
    }

    public void setHomePosition(@NotNull User owner, @NotNull String name, @NotNull Position position) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomePosition(optionalHome.get(), position);
    }

    public void setHomePosition(@NotNull Home home, @NotNull Position position) throws ValidationException {
        home.update(position);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeName(@NotNull User owner, @NotNull String name, @NotNull String newName) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeName(optionalHome.get(), newName);
    }

    public void setHomeName(@NotNull Home home, @NotNull String newName) throws ValidationException {
        this.plugin.getValidator().validateName(newName);
        home.getMeta().setName(newName);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeDescription(@NotNull User owner, @NotNull String name, @NotNull String description) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeDescription(optionalHome.get(), description);
    }

    public void setHomeDescription(@NotNull Home home, @NotNull String description) {
        this.plugin.getValidator().validateDescription(description);
        home.getMeta().setDescription(description);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomePrivacy(@NotNull User owner, @NotNull String name, boolean isPublic) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomePrivacy(optionalHome.get(), isPublic);
    }

    public void setHomePrivacy(@NotNull Home home, boolean isPublic) {
        User user;
        if (isPublic && (user = home.getOwner()) instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            int publicHomes = this.plugin.getDatabase().getHomes(home.getOwner()).stream().filter(Home::isPublic).toList().size();
            if (publicHomes >= this.getMaxPublicHomes(online)) {
                throw new ValidationException(ValidationException.Type.REACHED_MAX_PUBLIC_HOMES);
            }
        }
        home.setPublic(isPublic);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public void setHomeMetaTags(@NotNull User owner, @NotNull String name, @NotNull Map<String, String> tags) throws ValidationException {
        Optional<Home> optionalHome = this.plugin.getDatabase().getHome(owner, name);
        if (optionalHome.isEmpty()) {
            throw new ValidationException(ValidationException.Type.NOT_FOUND);
        }
        this.setHomeMetaTags(optionalHome.get(), tags);
    }

    public void setHomeMetaTags(@NotNull Home home, @NotNull Map<String, String> tags) {
        home.getMeta().setTags(tags);
        this.plugin.getDatabase().saveHome(home);
        this.cacheHome(home, true);
    }

    public int getMaxHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getMaxHomes(this.plugin.getSettings().getMaxHomes(), this.plugin.getSettings().doStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getMaxHomes();
        }
        return n;
    }

    public int getMaxPublicHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getMaxPublicHomes(this.plugin.getSettings().getMaxPublicHomes(), this.plugin.getSettings().doStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getMaxPublicHomes();
        }
        return n;
    }

    public int getFreeHomes(@Nullable User user) {
        int n;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            n = online.getFreeHomes(this.plugin.getSettings().getFreeHomeSlots(), this.plugin.getSettings().doStackPermissionLimits());
        } else {
            n = this.plugin.getSettings().getFreeHomeSlots();
        }
        return n;
    }
}

