/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.PaperHuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.listener.BukkitEventListener;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.util.BukkitAdapter;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PaperEventListener
extends BukkitEventListener
implements Listener {
    public PaperEventListener(@NotNull PaperHuskHomes plugin) {
        super(plugin);
        this.usePaperEvents = true;
    }

    @Override
    @NotNull
    public PaperEventListener register(@NotNull BukkitHuskHomes plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        return this;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerUpdateRespawnLocation(PlayerSetSpawnEvent event) {
        if (!this.plugin.getSettings().doCrossServer() || !this.plugin.getSettings().isGlobalRespawning()) {
            return;
        }
        Location location = event.getLocation();
        if (location == null) {
            return;
        }
        BukkitAdapter.adaptLocation(location).ifPresent(adaptedLocation -> super.handlePlayerUpdateSpawnPoint(BukkitUser.adapt(event.getPlayer(), (PaperHuskHomes)this.plugin), Position.at(adaptedLocation, this.plugin.getServerName())));
    }

    @Override
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (event.getRespawnReason() != PlayerRespawnEvent.RespawnReason.DEATH) {
            return;
        }
        super.handlePlayerRespawn(BukkitUser.adapt(event.getPlayer(), (BukkitHuskHomes)this.plugin));
    }
}

