/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.command.Node;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;

public class EventListener {
    @NotNull
    protected final HuskHomes plugin;

    protected EventListener(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    protected final void handlePlayerJoin(@NotNull OnlineUser onlineUser) {
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().ensureUser(onlineUser);
            if (this.plugin.getSettings().doCrossServer()) {
                this.handleInboundTeleport(onlineUser);
                this.plugin.runSyncDelayed(() -> this.synchronizeGlobalPlayerList(onlineUser, this.plugin.getLocalPlayerList()), 40L);
                if (this.plugin.getOnlineUsers().size() == 1) {
                    this.plugin.getManager().homes().updatePublicHomeCache();
                    this.plugin.getManager().warps().updateWarpCache();
                }
            }
            this.plugin.getManager().homes().cacheUserHomes(onlineUser);
            this.plugin.getDatabase().getUserData(onlineUser.getUuid()).ifPresent(userData -> {
                this.plugin.getSavedUsers().add((SavedUser)userData);
                if (userData.isIgnoringTeleports()) {
                    this.plugin.getLocales().getRawLocale("tpignore_on_notification", this.plugin.getLocales().getRawLocale("tpignore_toggle_button").orElse("")).ifPresent(locale -> onlineUser.sendMessage(new MineDown((String)locale)));
                }
            });
        });
    }

    protected final void handlePlayerLeave(@NotNull OnlineUser onlineUser) {
        this.plugin.runAsync(() -> {
            this.plugin.getDatabase().setOfflinePosition(onlineUser, onlineUser.getPosition());
            this.plugin.getManager().homes().removeUserHomes(onlineUser);
            if (this.plugin.getSettings().doCrossServer()) {
                List<String> localPlayerList = this.plugin.getLocalPlayerList().stream().filter(player -> !player.equals(onlineUser.getUsername())).toList();
                if (this.plugin.getSettings().getBrokerType() == Broker.Type.REDIS) {
                    this.synchronizeGlobalPlayerList(onlineUser, localPlayerList);
                    return;
                }
                this.plugin.getOnlineUsers().stream().filter(user -> !user.equals(onlineUser)).findAny().ifPresent(player -> this.synchronizeGlobalPlayerList((OnlineUser)player, localPlayerList));
            }
        });
    }

    private void handleInboundTeleport(@NotNull OnlineUser teleporter) {
        this.plugin.getDatabase().getCurrentTeleport(teleporter).ifPresent(teleport -> {
            if (teleport.getType() == Teleport.Type.RESPAWN) {
                this.handleInboundRespawn(teleporter);
                return;
            }
            try {
                teleporter.teleportLocally((Position)teleport.getTarget(), this.plugin.getSettings().doAsynchronousTeleports());
            }
            catch (TeleportationException e) {
                e.displayMessage(teleporter, new String[0]);
            }
            this.plugin.getDatabase().clearCurrentTeleport(teleporter);
            teleport.displayTeleportingComplete(teleporter);
        });
    }

    private void handleInboundRespawn(@NotNull OnlineUser teleporter) {
        Optional<Position> bedPosition = teleporter.getBedSpawnPosition();
        if (bedPosition.isEmpty()) {
            this.plugin.getSpawn().ifPresent(spawn -> {
                if (this.plugin.getSettings().doCrossServer() && !spawn.getServer().equals(this.plugin.getServerName())) {
                    this.plugin.runSyncDelayed(() -> {
                        try {
                            Teleport.builder(this.plugin).teleporter(teleporter).target((Target)spawn).updateLastPosition(false).toTeleport().execute();
                        }
                        catch (TeleportationException e) {
                            e.displayMessage(teleporter, new String[0]);
                        }
                    }, 40L);
                } else {
                    try {
                        teleporter.teleportLocally((Location)spawn, this.plugin.getSettings().doAsynchronousTeleports());
                    }
                    catch (TeleportationException e) {
                        e.displayMessage(teleporter, new String[0]);
                    }
                }
                teleporter.sendTranslatableMessage("block.minecraft.spawn.not_valid");
            });
        } else {
            try {
                teleporter.teleportLocally(bedPosition.get(), this.plugin.getSettings().doAsynchronousTeleports());
            }
            catch (TeleportationException e) {
                e.displayMessage(teleporter, new String[0]);
            }
        }
        this.plugin.getDatabase().clearCurrentTeleport(teleporter);
        this.plugin.getDatabase().setRespawnPosition(teleporter, bedPosition.orElse(null));
    }

    private void synchronizeGlobalPlayerList(@NotNull OnlineUser user, @NotNull List<String> localPlayerList) {
        Message.builder().type(Message.Type.PLAYER_LIST).scope(Message.Scope.SERVER).target("ALL").payload(Payload.withStringList(localPlayerList)).build().send(this.plugin.getMessenger(), user);
        if (this.plugin.getOnlineUsers().size() == 1) {
            this.plugin.getGlobalPlayerList().clear();
            Message.builder().type(Message.Type.REQUEST_PLAYER_LIST).scope(Message.Scope.SERVER).target("ALL").build().send(this.plugin.getMessenger(), user);
        }
    }

    protected final void handlePlayerDeath(@NotNull OnlineUser onlineUser) {
        if (this.plugin.getSettings().doBackCommandReturnByDeath()) {
            if (this.plugin.getCommand(BackCommand.class).map(rec$ -> ((Node)rec$).getPermission(new String[0])).map(onlineUser::hasPermission).orElse(false).booleanValue()) {
                this.plugin.getDatabase().setLastPosition(onlineUser, onlineUser.getPosition());
            }
        }
    }

    protected final void handlePlayerRespawn(@NotNull OnlineUser onlineUser) {
        this.plugin.runAsync(() -> {
            boolean canReturnByDeath = this.plugin.getCommand(BackCommand.class).map(command -> onlineUser.hasPermission(command.getPermission(new String[0])) && onlineUser.hasPermission(command.getPermission("death"))).orElse(false);
            if (this.plugin.getSettings().doBackCommandReturnByDeath() && canReturnByDeath) {
                this.plugin.getLocales().getLocale("return_by_death_notification").ifPresent(onlineUser::sendMessage);
            }
            if (this.plugin.getSettings().doCrossServer() && this.plugin.getSettings().isGlobalRespawning()) {
                this.respawnGlobally(onlineUser);
            }
        });
    }

    private void respawnGlobally(@NotNull OnlineUser onlineUser) {
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(onlineUser).type(Teleport.Type.RESPAWN).updateLastPosition(false);
        this.plugin.getDatabase().getRespawnPosition(onlineUser).or(() -> {
            builder.type(Teleport.Type.TELEPORT);
            return this.plugin.getSpawn();
        }).ifPresent(position -> {
            builder.target((Target)position);
            try {
                builder.toTeleport().execute();
            }
            catch (TeleportationException e) {
                e.displayMessage(onlineUser, new String[0]);
            }
        });
    }

    protected final void handlePlayerTeleport(@NotNull OnlineUser onlineUser, @NotNull Position sourcePosition) {
        if (!this.plugin.getSettings().doBackCommandSaveOnTeleportEvent()) {
            return;
        }
        this.plugin.runAsync(() -> this.plugin.getDatabase().getUserData(onlineUser.getUuid()).ifPresent(data -> this.plugin.getDatabase().setLastPosition(data.getUser(), sourcePosition)));
    }

    protected final void handlePlayerUpdateSpawnPoint(@NotNull OnlineUser onlineUser, @NotNull Position position) {
        if (this.plugin.getSettings().doCrossServer() && this.plugin.getSettings().isGlobalRespawning()) {
            this.plugin.getDatabase().setRespawnPosition(onlineUser, position);
        }
    }

    public final void handlePluginDisable() {
        this.plugin.log(Level.INFO, "Successfully disabled HuskHomes v" + this.plugin.getVersion(), new Throwable[0]);
    }
}

