/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.listener;

import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.listener.EventListener;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.util.BukkitAdapter;
import org.bukkit.Location;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class BukkitEventListener
extends EventListener
implements Listener {
    protected boolean usePaperEvents = false;

    public BukkitEventListener(@NotNull BukkitHuskHomes plugin) {
        super(plugin);
    }

    @NotNull
    public BukkitEventListener register(@NotNull BukkitHuskHomes plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        return this;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        super.handlePlayerJoin(BukkitUser.adapt(event.getPlayer(), (BukkitHuskHomes)this.plugin));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeave(PlayerQuitEvent event) {
        super.handlePlayerLeave(BukkitUser.adapt(event.getPlayer(), (BukkitHuskHomes)this.plugin));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        super.handlePlayerDeath(BukkitUser.adapt(event.getEntity(), (BukkitHuskHomes)this.plugin));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.usePaperEvents) {
            return;
        }
        super.handlePlayerRespawn(BukkitUser.adapt(event.getPlayer(), (BukkitHuskHomes)this.plugin));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.COMMAND && event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN) {
            return;
        }
        BukkitUser bukkitUser = BukkitUser.adapt(player, (BukkitHuskHomes)this.plugin);
        BukkitAdapter.adaptLocation(event.getFrom()).ifPresent(sourceLocation -> this.handlePlayerTeleport(bukkitUser, Position.at(sourceLocation, this.plugin.getServerName())));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerUpdateRespawnLocation(PlayerInteractEvent event) {
        if (this.usePaperEvents || !this.plugin.getSettings().doCrossServer() || !this.plugin.getSettings().isGlobalRespawning()) {
            return;
        }
        if (event.getClickedBlock() == null || !(event.getClickedBlock().getBlockData() instanceof Bed) && !(event.getClickedBlock().getBlockData() instanceof RespawnAnchor)) {
            return;
        }
        Location location = event.getPlayer().getBedSpawnLocation();
        if (location == null) {
            return;
        }
        BukkitAdapter.adaptLocation(location).ifPresent(adaptedLocation -> super.handlePlayerUpdateSpawnPoint(BukkitUser.adapt(event.getPlayer(), (BukkitHuskHomes)this.plugin), Position.at(adaptedLocation, this.plugin.getServerName())));
    }
}

