/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.paperlib.scheduling;

import net.william278.huskhomes.libraries.paperlib.MorePaperLib;
import net.william278.huskhomes.libraries.paperlib.scheduling.AsynchronousScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.AttachedScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.BukkitSchedulerAsAsynchronousScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.BukkitSchedulerAsRegionalScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.EntitySpecificScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.FoliaDetection;
import net.william278.huskhomes.libraries.paperlib.scheduling.GlobalAsyncScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.GlobalScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.RegionSpecificScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.RegionalScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.StandardFoliaDetection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class GracefulScheduling {
    private final MorePaperLib morePaperLib;
    private final FoliaDetection foliaDetection;

    public GracefulScheduling(MorePaperLib morePaperLib, FoliaDetection foliaDetection) {
        this.morePaperLib = morePaperLib;
        this.foliaDetection = foliaDetection;
    }

    public GracefulScheduling(MorePaperLib morePaperLib) {
        this(morePaperLib, StandardFoliaDetection.INSTANCE);
    }

    public boolean isUsingFolia() {
        return this.foliaDetection.isUsingFolia();
    }

    public AsynchronousScheduler asyncScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalAsyncScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsAsynchronousScheduler(this.morePaperLib);
    }

    public RegionalScheduler globalRegionalScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public RegionalScheduler regionSpecificScheduler(Location location) {
        return this.regionSpecificScheduler(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public RegionalScheduler regionSpecificScheduler(World world, int chunkX, int chunkZ) {
        if (this.isUsingFolia()) {
            return new RegionSpecificScheduler(this.morePaperLib.getPlugin(), world, chunkX, chunkZ);
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public AttachedScheduler entitySpecificScheduler(Entity entity) {
        if (this.isUsingFolia()) {
            return new EntitySpecificScheduler(entity, this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).asAttachedScheduler();
    }

    public boolean isOnGlobalRegionThread() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.isUsingFolia()) {
            return server.isGlobalTickThread();
        }
        return server.isPrimaryThread();
    }

    public void cancelGlobalTasks() {
        if (this.isUsingFolia()) {
            new GlobalAsyncScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            new GlobalScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            return;
        }
        new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).cancelTasks();
    }
}

