/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.commons.text.similarity;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.huskhomes.libraries.commons.lang3.ArrayUtils;
import net.william278.huskhomes.libraries.commons.lang3.StringUtils;
import net.william278.huskhomes.libraries.commons.lang3.Validate;
import net.william278.huskhomes.libraries.commons.text.similarity.CharSequenceTokenizer;

final class RegexTokenizer
implements CharSequenceTokenizer<CharSequence> {
    private static final Pattern PATTERN = Pattern.compile("(\\w)+");
    static final RegexTokenizer INSTANCE = new RegexTokenizer();

    RegexTokenizer() {
    }

    @Override
    public CharSequence[] apply(CharSequence text) {
        Validate.isTrue(StringUtils.isNotBlank(text), "Invalid text", new Object[0]);
        Matcher matcher = PATTERN.matcher(text);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group(0));
        }
        return tokens.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

