/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.commons.text.lookup;

import java.util.Date;
import net.william278.huskhomes.libraries.commons.lang3.time.FastDateFormat;
import net.william278.huskhomes.libraries.commons.text.lookup.AbstractStringLookup;
import net.william278.huskhomes.libraries.commons.text.lookup.IllegalArgumentExceptions;

final class DateStringLookup
extends AbstractStringLookup {
    static final DateStringLookup INSTANCE = new DateStringLookup();

    private DateStringLookup() {
    }

    private String formatDate(long dateMillis, String format) {
        FastDateFormat dateFormat = null;
        if (format != null) {
            try {
                dateFormat = FastDateFormat.getInstance(format);
            }
            catch (Exception ex) {
                throw IllegalArgumentExceptions.format(ex, "Invalid date format: [%s]", format);
            }
        }
        if (dateFormat == null) {
            dateFormat = FastDateFormat.getInstance();
        }
        return dateFormat.format(new Date(dateMillis));
    }

    @Override
    public String lookup(String key) {
        return this.formatDate(System.currentTimeMillis(), key);
    }
}

