/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.commodore.file;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.Collection;
import net.william278.huskhomes.libraries.commodore.file.ArgumentTypeParser;
import net.william278.huskhomes.libraries.commodore.file.Lexer;
import net.william278.huskhomes.libraries.commodore.file.ParseException;
import net.william278.huskhomes.libraries.commodore.file.Token;

class Parser<S> {
    private final Lexer lexer;
    private final Collection<ArgumentTypeParser> argumentTypeParsers;

    Parser(Lexer lexer, Collection<ArgumentTypeParser> argumentTypeParsers) {
        this.lexer = lexer;
        this.argumentTypeParsers = argumentTypeParsers;
    }

    LiteralCommandNode<S> parse() throws ParseException {
        CommandNode<S> node = this.parseNode();
        if (!(node instanceof LiteralCommandNode)) {
            throw this.lexer.createException("Root command node is not a literal command node");
        }
        if (this.lexer.peek() != Token.ConstantToken.EOF) {
            throw this.lexer.createException("Expected end of file but got " + this.lexer.peek());
        }
        return (LiteralCommandNode)node;
    }

    private CommandNode<S> parseNode() throws ParseException {
        Token token = (Token)this.lexer.next();
        if (!(token instanceof Token.StringToken)) {
            throw this.lexer.createException("Expected string token for node name but got " + token);
        }
        String name = ((Token.StringToken)token).getString();
        Object node = this.lexer.peek() instanceof Token.StringToken ? RequiredArgumentBuilder.argument((String)name, this.parseArgumentType()) : LiteralArgumentBuilder.literal((String)name);
        if (this.lexer.peek() == Token.ConstantToken.OPEN_BRACKET) {
            this.lexer.next();
            while (this.lexer.peek() != Token.ConstantToken.CLOSE_BRACKET) {
                CommandNode<S> child = this.parseNode();
                node.then(child);
            }
            this.lexer.next();
        } else {
            if (this.lexer.peek() != Token.ConstantToken.SEMICOLON) {
                throw this.lexer.createException("Node definition not ended with semicolon, got " + this.lexer.peek());
            }
            this.lexer.next();
        }
        return node.build();
    }

    private ArgumentType<?> parseArgumentType() throws ParseException {
        Token token = (Token)this.lexer.next();
        if (!(token instanceof Token.StringToken)) {
            throw this.lexer.createException("Expected string token for argument type but got " + token);
        }
        String argumentType = ((Token.StringToken)token).getString();
        Object[] key = argumentType.split(":");
        if (key.length != 2) {
            throw this.lexer.createException("Invalid key for argument type: " + Arrays.toString(key));
        }
        for (ArgumentTypeParser parser : this.argumentTypeParsers) {
            if (!parser.canParse((String)key[0], (String)key[1])) continue;
            return parser.parse((String)key[0], (String)key[1], this.lexer);
        }
        throw this.lexer.createException("Unable to parse argument type: " + argumentType);
    }
}

