/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.annotaml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.william278.huskhomes.libraries.annotaml.Annotaml;
import net.william278.huskhomes.libraries.annotaml.YamlComment;
import net.william278.huskhomes.libraries.annotaml.YamlFile;
import net.william278.huskhomes.libraries.annotaml.YamlIgnored;
import net.william278.huskhomes.libraries.annotaml.YamlKey;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.boostedyaml.YamlDocument;
import net.william278.huskhomes.libraries.boostedyaml.block.implementation.Section;
import net.william278.huskhomes.libraries.boostedyaml.utils.conversion.PrimitiveConversions;

public class YamlObjectMap<T>
extends LinkedHashMap<String, Object> {
    @NotNull
    private final Class<T> objectClass;
    @NotNull
    private final Map<String, String> comments;

    protected YamlObjectMap(@NotNull T object) throws IllegalArgumentException {
        if (!object.getClass().isAnnotationPresent(YamlFile.class)) {
            throw new IllegalArgumentException("Object type must be annotated with @YamlFile");
        }
        this.objectClass = object.getClass();
        this.comments = new LinkedHashMap<String, String>();
        this.readDefaults(object);
    }

    protected static <T> YamlObjectMap<T> parse(@NotNull T defaults, @NotNull InputStream yaml) throws IllegalArgumentException, IOException {
        return new YamlObjectMap<T>(defaults).readFromYaml(YamlDocument.create(yaml));
    }

    private void readDefaults(@NotNull T object) throws IllegalArgumentException {
        if (!object.getClass().isAnnotationPresent(YamlFile.class)) {
            throw new IllegalArgumentException("Object type must be annotated with @YamlFile");
        }
        boolean rootedMap = object.getClass().getAnnotation(YamlFile.class).rootedMap();
        Field[] fields = object.getClass().getDeclaredFields();
        int fieldIndex = 0;
        for (Field field : fields) {
            String headerComment;
            String key;
            field.setAccessible(true);
            if (field.isAnnotationPresent(YamlIgnored.class)) continue;
            String string = rootedMap ? "" : (key = field.isAnnotationPresent(YamlKey.class) ? field.getAnnotation(YamlKey.class).value() : field.getName());
            if (fieldIndex == 0 && !(headerComment = this.getObjectClass().getAnnotation(YamlFile.class).header()).isEmpty()) {
                this.comments.put(key, headerComment);
            }
            if (field.isAnnotationPresent(YamlComment.class)) {
                if (this.comments.containsKey(key)) {
                    this.comments.put(key, this.comments.get(key) + "\n" + field.getAnnotation(YamlComment.class).value());
                } else {
                    this.comments.put(key, field.getAnnotation(YamlComment.class).value());
                }
            }
            if (rootedMap) {
                try {
                    this.readFieldValue(field, object).ifPresent(value -> this.putAll((Map)value));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to read rooted map value " + field.getName(), e);
                }
                return;
            }
            try {
                Optional<Object> value2 = this.readFieldValue(field, object);
                this.put(key, value2.orElse(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to read field " + field.getName() + " from object " + object.getClass().getName() + " to map at YAML path " + field.getName(), e);
            }
            ++fieldIndex;
        }
    }

    private T applyMapTo(@NotNull T defaults) throws IllegalArgumentException {
        Field[] fields;
        boolean rootedMap = defaults.getClass().getAnnotation(YamlFile.class).rootedMap();
        for (Field field : fields = defaults.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(YamlIgnored.class)) continue;
            if (rootedMap) {
                if (!field.getType().equals(Map.class)) {
                    throw new IllegalArgumentException("Field " + field.getName() + " is part of a rooted map but is not a Map (is " + field.getType().getName() + ")");
                }
                try {
                    this.writeFieldValue(field, defaults, this);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to write rooted field " + field.getName() + " from object " + defaults.getClass().getName() + " to " + field.getName(), e);
                }
                return defaults;
            }
            String key = field.isAnnotationPresent(YamlKey.class) ? field.getAnnotation(YamlKey.class).value() : field.getName();
            Optional.ofNullable(this.get(key)).ifPresent(value -> {
                try {
                    this.writeFieldValue(field, defaults, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to write field " + field.getName() + " from object " + defaults.getClass().getName() + " to YAML path " + field.getName(), e);
                }
            });
        }
        return defaults;
    }

    private <Y> void writeFieldValue(@NotNull Field field, @NotNull T object, @NotNull Y value) throws IllegalAccessException, IllegalArgumentException {
        Object settableObject;
        field.setAccessible(true);
        Class<?> fieldClass = field.getType();
        Object object2 = fieldClass.isInstance(value) ? value : (PrimitiveConversions.isNumber(value.getClass()) && PrimitiveConversions.isNumber(fieldClass) ? PrimitiveConversions.convertNumber(value, fieldClass) : (settableObject = PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(value.getClass()) && PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(fieldClass) ? value : null));
        if (value instanceof Section) {
            Map<String, Object> map = ((Section)value).getStringRouteMappedValues(false);
            settableObject = map;
            if (fieldClass == TreeMap.class) {
                settableObject = new TreeMap<String, Object>(map);
            } else if (fieldClass == LinkedHashMap.class) {
                settableObject = new LinkedHashMap<String, Object>(map);
            } else if (fieldClass == HashMap.class) {
                settableObject = new HashMap<String, Object>(map);
            } else if (fieldClass == ConcurrentHashMap.class) {
                settableObject = new ConcurrentHashMap<String, Object>(map);
            }
        }
        if (fieldClass.isEnum()) {
            try {
                settableObject = Enum.valueOf(fieldClass, value.toString());
            }
            catch (IllegalArgumentException e) {
                for (Enum enumValue : (Enum[])fieldClass.getEnumConstants()) {
                    if (!enumValue.name().equalsIgnoreCase(value.toString())) continue;
                    settableObject = enumValue;
                    break;
                }
            }
        }
        if (settableObject == null) {
            throw new IllegalArgumentException("Unable to set field " + field.getName() + " of type " + fieldClass.getName() + " to value " + value);
        }
        field.set(object, settableObject);
    }

    private Optional<Object> readFieldValue(@NotNull Field field, @NotNull T object) throws IllegalAccessException {
        field.setAccessible(true);
        if (field.getType().isEnum()) {
            return Optional.ofNullable(field.get(object)).map(Object::toString);
        }
        return Optional.ofNullable(field.get(object));
    }

    @NotNull
    private YamlObjectMap<T> readFromYaml(@NotNull YamlDocument yamlDocument) {
        if (this.getObjectClass().getAnnotation(YamlFile.class).rootedMap()) {
            this.clear();
            this.putAll(yamlDocument.getStringRouteMappedValues(false));
            return this;
        }
        this.forEach((key, value) -> this.put(key, yamlDocument.get((String)key)));
        return this;
    }

    public void save(@NotNull File file) throws IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Unable to create parent directories for file " + file.getAbsolutePath());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Unable to create file " + file.getAbsolutePath());
        }
        YamlDocument yamlDocument = YamlDocument.create(file);
        this.forEach((key, value) -> {
            yamlDocument.set((String)key, value);
            if (this.comments.containsKey(key)) {
                yamlDocument.getBlock((String)key).setComments(Arrays.stream(this.comments.get(key).split("\\r?\\n")).map(String::trim).map(comment -> " " + comment).collect(Collectors.toList()));
            }
        });
        yamlDocument.save();
    }

    @NotNull
    protected T getObject() throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.applyMapTo(Annotaml.getDefaults(this.objectClass));
    }

    @NotNull
    protected Class<T> getObjectClass() {
        return this.objectClass;
    }
}

