/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.annotaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import net.william278.huskhomes.libraries.annotaml.YamlFile;
import net.william278.huskhomes.libraries.annotaml.YamlObjectMap;
import net.william278.huskhomes.libraries.annotations.NotNull;

public class Annotaml<T> {
    @NotNull
    private final Class<T> objectClass;
    @NotNull
    private final YamlObjectMap<T> yamlObjectMap;

    private Annotaml(@NotNull T object) throws IllegalArgumentException {
        if (!object.getClass().isAnnotationPresent(YamlFile.class)) {
            throw new IllegalArgumentException("Object type must be annotated with @YamlFile");
        }
        this.objectClass = object.getClass();
        this.yamlObjectMap = new YamlObjectMap<T>(object);
    }

    private Annotaml(@NotNull YamlObjectMap<T> yamlObjectMap) {
        this.yamlObjectMap = yamlObjectMap;
        this.objectClass = yamlObjectMap.getObjectClass();
    }

    @NotNull
    public static <T> Annotaml<T> create(@NotNull File file, @NotNull Class<T> objectClass) throws IOException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return Annotaml.create(file, Annotaml.getDefaults(objectClass));
    }

    @NotNull
    public static <T> Annotaml<T> create(@NotNull File file, @NotNull T object) throws IOException {
        Annotaml<T> annotaml;
        Annotaml<T> annotaml2 = annotaml = file.exists() ? Annotaml.create(object, (InputStream)new FileInputStream(file)) : Annotaml.create(object);
        if (!file.exists()) {
            annotaml.save(file);
        }
        return annotaml;
    }

    @NotNull
    public static <T> Annotaml<T> create(@NotNull T object) {
        return new Annotaml<T>(object);
    }

    @NotNull
    public static <T> Annotaml<T> create(@NotNull T defaults, @NotNull InputStream inputStream) throws IOException {
        return new Annotaml<T>(YamlObjectMap.parse(defaults, inputStream));
    }

    @NotNull
    public static <T> Annotaml<T> create(@NotNull Class<T> objectClass, @NotNull InputStream inputStream) throws IOException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return new Annotaml<T>(YamlObjectMap.parse(Annotaml.getDefaults(objectClass), inputStream));
    }

    public void save(@NotNull File file) throws IllegalArgumentException, IOException {
        this.yamlObjectMap.save(file);
    }

    @NotNull
    public T get() throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.yamlObjectMap.getObject();
    }

    protected static <T> T getDefaults(@NotNull Class<T> objectClass) throws InvocationTargetException, InstantiationException, IllegalAccessException, IllegalArgumentException {
        Optional<Constructor> constructors = Arrays.stream(objectClass.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findFirst();
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException("Class type must have a zero-argument constructor: " + objectClass.getName());
        }
        Constructor constructor2 = constructors.get();
        constructor2.setAccessible(true);
        Object defaults = constructor2.newInstance(new Object[0]);
        return defaults;
    }
}

