/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.importer;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.adventure.text.Component;
import net.william278.huskhomes.libraries.adventure.text.format.TextColor;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;

public abstract class Importer
extends Hook {
    protected final HuskHomes plugin;
    private final String name;
    private final List<ImportData> supportedImportData;

    protected Importer(@NotNull String name, @NotNull List<ImportData> supportedData, @NotNull HuskHomes plugin) {
        super(plugin, name + " Importer");
        this.name = name;
        this.supportedImportData = supportedData;
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
    }

    public final void start(@NotNull CommandUser user) {
        LocalDateTime startTime = LocalDateTime.now();
        this.log(user, Level.INFO, "\u231a Starting " + this.name + " data import...", new Throwable[0]);
        for (ImportData data : this.supportedImportData) {
            try {
                this.log(user, Level.INFO, "\u231a Importing " + data.getName() + "...", new Throwable[0]);
                int entries = this.importData(data);
                this.log(user, Level.INFO, "\u2714 Imported " + data.getName() + " (" + entries + " entries)", new Throwable[0]);
            }
            catch (Throwable e) {
                this.log(user, Level.WARNING, "\u274c Failed to import " + data.getName() + ": " + e.getMessage(), e);
                return;
            }
        }
        long timeTaken = startTime.until(LocalDateTime.now(), ChronoUnit.SECONDS);
        this.log(user, Level.INFO, "\u2714 Completed import from " + this.name + " (took " + timeTaken + "s)", new Throwable[0]);
    }

    protected abstract int importData(@NotNull ImportData var1) throws Throwable;

    protected final void log(@NotNull CommandUser user, @NotNull Level level, @NotNull String message, Throwable ... e) {
        message = "[Importer] " + (String)message;
        if (user instanceof OnlineUser) {
            OnlineUser online = (OnlineUser)user;
            TextColor color = level == Level.SEVERE || level == Level.WARNING ? TextColor.color(0xFF3300) : TextColor.color(0xC3C3C3);
            online.sendMessage(Component.text((String)message, color));
        }
        this.plugin.log(level, (String)message, e);
    }

    @NotNull
    public String getImporterName() {
        return this.name;
    }

    @NotNull
    public List<ImportData> getSupportedImportData() {
        return this.supportedImportData;
    }

    public static enum ImportData {
        USERS("User Data"),
        HOMES("Homes"),
        WARPS("Warps");

        private final String name;

        private ImportData(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

