/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.importer;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.commands.WarpNotFoundException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.util.BukkitAdapter;
import net.william278.huskhomes.util.ValidationException;

public class EssentialsXImporter
extends Importer {
    private final Essentials essentials;

    public EssentialsXImporter(@NotNull HuskHomes plugin) {
        super("EssentialsX", List.of(Importer.ImportData.HOMES, Importer.ImportData.WARPS), plugin);
        this.essentials = (Essentials)((BukkitHuskHomes)plugin).getServer().getPluginManager().getPlugin("Essentials");
    }

    private int importHomes() {
        AtomicInteger homesImported = new AtomicInteger();
        for (UUID uuid : this.essentials.getUsers().getAllUserUUIDs()) {
            User essentialsUser = this.essentials.getUser(uuid);
            if (essentialsUser == null || essentialsUser.getName() == null) continue;
            net.william278.huskhomes.user.User user = net.william278.huskhomes.user.User.of(uuid, essentialsUser.getName());
            this.plugin.getDatabase().ensureUser(user);
            for (String homeName : essentialsUser.getHomes()) {
                if (essentialsUser.getHome(homeName) == null || essentialsUser.getHome(homeName).getWorld() == null) continue;
                BukkitAdapter.adaptLocation(essentialsUser.getHome(homeName)).map(location -> Position.at(location, this.plugin.getServerName())).ifPresent(position -> {
                    this.plugin.getManager().homes().createHome(user, this.normalizeName(homeName), (Position)position, true, true, true);
                    homesImported.getAndIncrement();
                });
            }
        }
        return homesImported.get();
    }

    private int importWarps() throws Throwable {
        AtomicInteger warpsImported = new AtomicInteger();
        Warps warps = this.essentials.getWarps();
        for (String warpName : warps.getList()) {
            try {
                if (warps.getWarp(warpName) == null || warps.getWarp(warpName).getWorld() == null) continue;
                BukkitAdapter.adaptLocation(warps.getWarp(warpName)).map(location -> Position.at(location, this.plugin.getServerName())).ifPresent(position -> {
                    this.plugin.getManager().warps().createWarp(this.normalizeName(warpName), (Position)position, true);
                    warpsImported.getAndIncrement();
                });
            }
            catch (WarpNotFoundException e) {
                this.plugin.log(Level.WARNING, String.format("Skipped importing warp %s (could not be found)", warpName), new Throwable[0]);
            }
        }
        return warpsImported.get();
    }

    @NotNull
    private String normalizeName(@NotNull String name) {
        try {
            this.plugin.getValidator().validateName((String)name);
            return name;
        }
        catch (ValidationException e) {
            name = ((String)name).replaceAll(" ", "_");
            if (this.plugin.getSettings().doRestrictNames()) {
                name = ((String)name).replaceAll("[^A-Za-z0-9_-]", "");
            }
            if (((String)name).isBlank()) {
                name = "imported-" + UUID.randomUUID().toString().substring(0, 5);
            }
            if (((String)name).length() > 16) {
                name = ((String)name).substring(0, 16);
            }
            return name;
        }
    }

    @Override
    protected int importData(@NotNull Importer.ImportData importData) throws Throwable {
        return switch (importData) {
            default -> throw new IncompatibleClassChangeError();
            case Importer.ImportData.USERS -> 0;
            case Importer.ImportData.HOMES -> this.importHomes();
            case Importer.ImportData.WARPS -> this.importWarps();
        };
    }
}

