/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import com.djrapitops.plan.capability.CapabilityService;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ExtensionService;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.SavedUser;

public class PlanHook
extends Hook {
    private final HuskHomes plugin;

    public PlanHook(@NotNull HuskHomes plugin) {
        super(plugin, "Plan");
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        if (!this.areAllCapabilitiesAvailable()) {
            return;
        }
        this.registerDataExtension();
        this.handlePlanReload();
    }

    private boolean areAllCapabilitiesAvailable() {
        CapabilityService capabilities = CapabilityService.getInstance();
        return capabilities.hasCapability("DATA_EXTENSION_VALUES");
    }

    private void registerDataExtension() {
        try {
            ExtensionService.getInstance().register((DataExtension)new PlanDataExtension(this.plugin.getDatabase()));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.plugin.log(Level.SEVERE, "Failed to register HuskHomes Plan extension", e);
        }
    }

    private void handlePlanReload() {
        CapabilityService.getInstance().registerEnableListener(isPlanEnabled -> {
            if (isPlanEnabled.booleanValue()) {
                this.registerDataExtension();
            }
        });
    }

    @PluginInfo(name="HuskHomes", iconName="home", iconFamily=Family.SOLID, color=Color.LIGHT_BLUE)
    protected static class PlanDataExtension
    implements DataExtension {
        private static final String UNKNOWN_STRING = "N/A";
        private Database database;

        protected PlanDataExtension(@NotNull Database database) {
            this.database = database;
        }

        protected PlanDataExtension() {
        }

        public CallEvents[] callExtensionMethodsOn() {
            return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE};
        }

        @BooleanProvider(text="Has Data", description="Whether this user has HuskHomes data.", iconName="bell", iconFamily=Family.SOLID, conditionName="hasData", hidden=true)
        public boolean getHasUserData(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).isPresent();
        }

        @NumberProvider(text="Home Count", description="The number of homes this user has set.", iconName="home", iconFamily=Family.SOLID, priority=5)
        @Conditional(value="hasData")
        public long getHomeCount(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).map(userData -> this.database.getHomes(userData.getUser()).size()).orElse(0L);
        }

        @NumberProvider(text="Public Homes", description="The number of homes this user has made public.", iconName="sun", iconFamily=Family.SOLID, priority=4)
        @Conditional(value="hasData")
        public long getPublicHomeCount(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).map(userData -> this.database.getHomes(userData.getUser()).stream().filter(Home::isPublic).count()).orElse(0L);
        }

        @NumberProvider(text="Home Slots", description="The number of extra home slots this user has purchased.", iconName="money-check-alt", iconFamily=Family.SOLID, priority=3)
        @Conditional(value="hasData")
        public long getPurchasedHomeSlots(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).map(userData -> userData.getHomeSlots()).orElse(0L);
        }

        @BooleanProvider(text="Ignoring /tpa Requests", description="Whether this player is ignoring /tpa requests.", iconName="phone-slash", iconFamily=Family.SOLID, priority=2)
        @Conditional(value="hasData")
        public boolean isIgnoringTeleportRequests(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).map(SavedUser::isIgnoringTeleports).orElse(false);
        }

        @StringProvider(text="Offline Position", description="The location where this user logged out.", iconName="door-open", iconFamily=Family.SOLID, priority=1)
        @Conditional(value="hasData")
        public String getOfflinePosition(@NotNull UUID uuid) {
            return this.database.getUserData(uuid).map(userData -> this.database.getOfflinePosition(userData.getUser()).map(Position::toString).orElse(UNKNOWN_STRING)).orElse(UNKNOWN_STRING);
        }
    }
}

