/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.List;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.SavedUser;
import org.bukkit.OfflinePlayer;

public class PlaceholderAPIHook
extends Hook {
    public PlaceholderAPIHook(@NotNull BukkitHuskHomes plugin) {
        super(plugin, "PlaceholderAPI");
    }

    @Override
    public void initialize() {
        new HuskHomesExpansion((BukkitHuskHomes)this.plugin).register();
    }

    public static class HuskHomesExpansion
    extends PlaceholderExpansion {
        @NotNull
        private final BukkitHuskHomes plugin;

        private HuskHomesExpansion(@NotNull BukkitHuskHomes plugin) {
            this.plugin = plugin;
        }

        @Nullable
        public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
            if (offlinePlayer == null || !offlinePlayer.isOnline() || offlinePlayer.getPlayer() == null) {
                return "Player not online";
            }
            BukkitUser player = BukkitUser.adapt(offlinePlayer.getPlayer(), this.plugin);
            return switch (params) {
                case "homes_count" -> String.valueOf(this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getUsername(), List.of()).size());
                case "max_homes" -> String.valueOf(this.plugin.getManager().homes().getMaxHomes(player));
                case "max_public_homes" -> String.valueOf(this.plugin.getManager().homes().getMaxPublicHomes(player));
                case "free_home_slots" -> String.valueOf(this.plugin.getManager().homes().getFreeHomes(player));
                case "home_slots" -> String.valueOf(this.plugin.getSavedUser(player).map(SavedUser::getHomeSlots).orElse(0));
                case "homes_list" -> String.join((CharSequence)", ", this.plugin.getManager().homes().getUserHomes().getOrDefault(player.getUsername(), List.of()));
                case "public_homes_count" -> String.valueOf(this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getUsername(), List.of()).size());
                case "public_homes_list" -> String.join((CharSequence)", ", this.plugin.getManager().homes().getPublicHomes().getOrDefault(player.getUsername(), List.of()));
                case "ignoring_tp_requests" -> this.getBooleanValue(this.plugin.getManager().requests().isIgnoringRequests(player));
                default -> null;
            };
        }

        public boolean persist() {
            return true;
        }

        @NotNull
        public String getIdentifier() {
            return "huskhomes";
        }

        @NotNull
        public String getAuthor() {
            return "William278";
        }

        @NotNull
        public String getVersion() {
            return this.plugin.getVersion().toStringWithoutMetadata();
        }

        @NotNull
        private String getBooleanValue(boolean bool) {
            return bool ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
        }
    }
}

