/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.HashMap;
import java.util.Map;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.commons.text.StringEscapeUtils;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.User;

public abstract class MapHook
extends Hook {
    protected static final String WARP_MARKER_IMAGE_NAME = "warp";
    protected static final String PUBLIC_HOME_MARKER_IMAGE_NAME = "public-home";

    protected MapHook(@NotNull HuskHomes plugin, @NotNull String name) {
        super(plugin, name);
    }

    protected void populateMap() {
        if (this.plugin.getSettings().doPublicHomesOnMap()) {
            this.plugin.getDatabase().getLocalPublicHomes(this.plugin).forEach(this::updateHome);
        }
        if (this.plugin.getSettings().doWarpsOnMap()) {
            this.plugin.getDatabase().getLocalWarps(this.plugin).forEach(this::updateWarp);
        }
    }

    public abstract void updateHome(@NotNull Home var1);

    public abstract void removeHome(@NotNull Home var1);

    public abstract void clearHomes(@NotNull User var1);

    public abstract void clearHomes(@NotNull String var1);

    public abstract void updateWarp(@NotNull Warp var1);

    public abstract void removeWarp(@NotNull Warp var1);

    public abstract void clearWarps();

    public abstract void clearWarps(@NotNull String var1);

    protected final boolean isValidPosition(@NotNull SavedPosition position) {
        if (position instanceof Warp && !this.plugin.getSettings().doWarpsOnMap()) {
            return false;
        }
        if (position instanceof Home && !this.plugin.getSettings().doPublicHomesOnMap()) {
            return false;
        }
        return !this.plugin.getSettings().doCrossServer() || position.getServer().equals(this.plugin.getServerName());
    }

    @NotNull
    protected final String getPublicHomesKey() {
        return this.plugin.getKey(this.getName().toLowerCase(), "public_home_markers").toString();
    }

    @NotNull
    protected final String getWarpsKey() {
        return this.plugin.getKey(this.getName().toLowerCase(), "warp_markers").toString();
    }

    @NotNull
    protected final String getPublicHomesMarkerSetName() {
        return this.plugin.getLocales().getRawLocale("map_hook_public_homes_marker_set_name").orElse("Public Homes");
    }

    @NotNull
    protected final String getWarpsMarkerSetName() {
        return this.plugin.getLocales().getRawLocale("map_hook_warps_marker_set_name").orElse("Warps");
    }

    protected static class MarkerInformationPopup {
        @NotNull
        private final String title;
        @Nullable
        private String thumbnail;
        @NotNull
        private final Map<String, String> fields;

        private MarkerInformationPopup(@NotNull String title) {
            this.title = title;
            this.fields = new HashMap<String, String>();
        }

        @NotNull
        protected static MarkerInformationPopup warp(@NotNull Warp warp, @NotNull String thumbnail, @NotNull HuskHomes plugin) {
            return MarkerInformationPopup.create(warp.getName()).thumbnail(thumbnail).field("Description", plugin.getLocales().wrapText(warp.getMeta().getDescription(), 60)).field("Location", warp.toString()).field("Command", "/warp " + warp.getSafeIdentifier());
        }

        @NotNull
        protected static MarkerInformationPopup publicHome(@NotNull Home home, @NotNull String thumbnail, @NotNull HuskHomes plugin) {
            return MarkerInformationPopup.create(home.getName()).thumbnail(thumbnail).field("Owner", home.getOwner().getUsername()).field("Description", plugin.getLocales().wrapText(home.getMeta().getDescription(), 60)).field("Location", home.toString()).field("Command", "/phome " + home.getSafeIdentifier());
        }

        @NotNull
        protected static MarkerInformationPopup create(@NotNull String title) {
            return new MarkerInformationPopup(title);
        }

        @NotNull
        protected MarkerInformationPopup thumbnail(@NotNull String thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        @NotNull
        protected MarkerInformationPopup field(@NotNull String key, @NotNull String value) {
            this.fields.put(key, value);
            return this;
        }

        @NotNull
        protected String toHtml() {
            StringBuilder html = new StringBuilder();
            html.append("<div class=\"infowindow\">");
            if (this.thumbnail != null) {
                html.append("<img src=\"").append(this.thumbnail).append(".png\" class=\"thumbnail\"/>").append("&nbsp;");
            }
            html.append("<span style=\"font-weight: bold;\">").append(StringEscapeUtils.escapeHtml4(this.title)).append("</span><br/>");
            this.fields.forEach((key, value) -> html.append("<span style=\"font-weight: bold;\">").append(StringEscapeUtils.escapeHtml4(key)).append(": </span><span>").append(StringEscapeUtils.escapeHtml4(value)).append("</span><br/>"));
            return html.toString();
        }
    }
}

