/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.database;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;
import org.h2.jdbcx.JdbcConnectionPool;

public class H2Database
extends Database {
    private final File databaseFile;
    private static final String DATABASE_FILE_NAME = "HuskHomesData.h2";
    private JdbcConnectionPool connectionPool;

    public H2Database(@NotNull HuskHomes plugin) {
        super(plugin);
        this.databaseFile = new File(plugin.getDataFolder(), DATABASE_FILE_NAME);
    }

    private Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    @Override
    public void initialize() throws IllegalStateException {
        String url = String.format("jdbc:h2:%s", this.databaseFile.getAbsolutePath());
        this.connectionPool = JdbcConnectionPool.create((String)url, (String)"sa", (String)"sa");
        try (Connection connection = this.getConnection();){
            String[] databaseSchema = this.getSchemaStatements("database/h2_schema.sql");
            try (Statement statement = connection.createStatement();){
                for (String tableCreationStatement : databaseSchema) {
                    statement.execute(tableCreationStatement);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new IllegalStateException("Failed to initialize the H2 database", e);
        }
    }

    @Override
    protected int setPosition(@NotNull Position position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%positions_table%`\n    (`x`,`y`,`z`,`yaw`,`pitch`,`world_name`,`world_uuid`,`server_name`)\nVALUES\n    (?,?,?,?,?,?,?,?);"), 1);){
            statement.setDouble(1, position.getX());
            statement.setDouble(2, position.getY());
            statement.setDouble(3, position.getZ());
            statement.setFloat(4, position.getYaw());
            statement.setFloat(5, position.getPitch());
            statement.setString(6, position.getWorld().getName());
            statement.setString(7, position.getWorld().getUuid().toString());
            statement.setString(8, position.getServer());
            statement.executeUpdate();
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            throw new SQLException("Failed to insert position into database");
        }
    }

    @Override
    protected void updatePosition(int positionId, @NotNull Position position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("UPDATE `%positions_table%`\nSET `x`=?,\n`y`=?,\n`z`=?,\n`yaw`=?,\n`pitch`=?,\n`world_uuid`=?,\n`world_name`=?,\n`server_name`=?\nWHERE `id`=?"));){
            statement.setDouble(1, position.getX());
            statement.setDouble(2, position.getY());
            statement.setDouble(3, position.getZ());
            statement.setFloat(4, position.getYaw());
            statement.setFloat(5, position.getPitch());
            statement.setString(6, position.getWorld().getUuid().toString());
            statement.setString(7, position.getWorld().getName());
            statement.setString(8, position.getServer());
            statement.setDouble(9, positionId);
            statement.executeUpdate();
        }
    }

    @Override
    protected int setSavedPosition(@NotNull SavedPosition position, @NotNull Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%saved_positions_table%`\n    (`position_id`, `name`, `description`, `tags`, `timestamp`)\nVALUES\n    (?,?,?,?,?);"), 1);){
            statement.setInt(1, this.setPosition(position, connection));
            statement.setString(2, position.getName());
            statement.setString(3, position.getMeta().getDescription());
            statement.setString(4, position.getMeta().getSerializedTags());
            statement.setTimestamp(5, Timestamp.from(position.getMeta().getCreationTime()));
            statement.executeUpdate();
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            throw new SQLException("Failed to insert saved position into database");
        }
    }

    @Override
    protected void updateSavedPosition(int savedPositionId, @NotNull SavedPosition position, @NotNull Connection connection) throws SQLException {
        block12: {
            try (PreparedStatement selectStatement = connection.prepareStatement(this.formatStatementTables("SELECT `position_id`\nFROM `%saved_positions_table%`\nWHERE `id`=?;"));){
                selectStatement.setInt(1, savedPositionId);
                ResultSet resultSet = selectStatement.executeQuery();
                if (!resultSet.next()) break block12;
                int positionId = resultSet.getInt("position_id");
                this.updatePosition(positionId, position, connection);
                try (PreparedStatement updateStatement = connection.prepareStatement(this.formatStatementTables("UPDATE `%saved_positions_table%`\nSET `name`=?,\n`description`=?,\n`tags`=?\nWHERE `id`=?;"));){
                    updateStatement.setString(1, position.getName());
                    updateStatement.setString(2, position.getMeta().getDescription());
                    updateStatement.setString(3, position.getMeta().getSerializedTags());
                    updateStatement.setInt(4, savedPositionId);
                    updateStatement.executeUpdate();
                }
            }
        }
    }

    @Override
    public void ensureUser(@NotNull User onlineUser) {
        this.getUserData(onlineUser.getUuid()).ifPresentOrElse(existingUserData -> {
            if (!existingUserData.getUsername().equals(onlineUser.getUsername())) {
                try (Connection connection = this.getConnection();){
                    try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("UPDATE `%players_table%`\nSET `username`=?\nWHERE `uuid`=?"));){
                        statement.setString(1, onlineUser.getUsername());
                        statement.setString(2, existingUserData.getUserUuid().toString());
                        statement.executeUpdate();
                    }
                    this.plugin.log(Level.INFO, "Updated " + onlineUser.getUsername() + "'s name in the database (" + existingUserData.getUsername() + " -> " + onlineUser.getUsername() + ")", new Throwable[0]);
                }
                catch (SQLException e) {
                    this.plugin.log(Level.SEVERE, "Failed to update a player's name on the database", e);
                }
            }
        }, () -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%players_table%` (`uuid`,`username`)\nVALUES (?,?);"));){
                statement.setString(1, onlineUser.getUuid().toString());
                statement.setString(2, onlineUser.getUsername());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to insert a player into the database", e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SavedUser> getUserDataByName(@NotNull String name) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `uuid`, `username`, `home_slots`, `ignoring_requests`\nFROM `%players_table%`\nWHERE `username`=?"));){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<SavedUser> optional = Optional.of(new SavedUser(User.of(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")), resultSet.getInt("home_slots"), resultSet.getBoolean("ignoring_requests")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player by name from the database", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<SavedUser> getUserData(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `uuid`, `username`, `home_slots`, `ignoring_requests`\nFROM `%players_table%`\nWHERE `uuid`=?"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<SavedUser> optional = Optional.of(new SavedUser(User.of(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")), resultSet.getInt("home_slots"), resultSet.getBoolean("ignoring_requests")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player from uuid from the database", e);
        }
        return Optional.empty();
    }

    @Override
    public void deleteUserData(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();){
            PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `id`\n    IN ((SELECT `last_position` FROM `%players_table%` WHERE `uuid` = ?),\n        (SELECT `offline_position` FROM `%players_table%` WHERE `uuid` = ?),\n        (SELECT `respawn_position` FROM `%players_table%` WHERE `uuid` = ?));"));
            statement.setString(1, uuid.toString());
            statement.setString(2, uuid.toString());
            statement.setString(3, uuid.toString());
            statement.executeUpdate();
            statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%players_table%`\nWHERE `uuid`=?;"));
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a player from the database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Instant> getCooldown(@NotNull TransactionResolver.Action action, @NotNull User user) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `type`, `start_timestamp`, `end_timestamp`\nFROM `%cooldowns_table%`\nWHERE `player_uuid`=? AND `type`=?\nORDER BY `start_timestamp` DESC\nLIMIT 1;"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Instant> optional = Optional.of(resultSet.getTimestamp("end_timestamp").toInstant());
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch a player's cooldown from the database", e);
        }
        return Optional.empty();
    }

    @Override
    public void setCooldown(@NotNull TransactionResolver.Action action, @NotNull User user, @NotNull Instant cooldownExpiry) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%cooldowns_table%` (`player_uuid`, `type`, `start_timestamp`, `end_timestamp`)\nVALUES (?,?,?,?);"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            statement.setTimestamp(3, Timestamp.from(Instant.now()));
            statement.setTimestamp(4, Timestamp.from(cooldownExpiry));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to set a player's cooldown in the database", e);
        }
    }

    @Override
    public void removeCooldown(@NotNull TransactionResolver.Action action, @NotNull User user) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%cooldowns_table%`\nWHERE `player_uuid`=? AND `type`=?;"));){
            statement.setString(1, user.getUuid().toString());
            statement.setString(2, action.name().toLowerCase(Locale.ENGLISH));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to remove a player's cooldown from the database", e);
        }
    }

    @Override
    public List<Home> getHomes(@NotNull User user) {
        ArrayList<Home> userHomes = new ArrayList<Home>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%homes_table%`.`uuid` AS `home_uuid`, `owner_uuid`, `name`, `description`, `tags`,\n    `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`, `public`\nFROM `%homes_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%homes_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nINNER JOIN `%players_table%`\n    ON `%homes_table%`.`owner_uuid`=`%players_table%`.`uuid`\nWHERE `owner_uuid`=?\nORDER BY `name`;"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                userHomes.add(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), user, resultSet.getBoolean("public")));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for home data for:" + user.getUsername(), new Throwable[0]);
        }
        return userHomes;
    }

    @Override
    public List<Warp> getWarps() {
        ArrayList<Warp> warps = new ArrayList<Warp>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%warps_table%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warps_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%warps_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nORDER BY `name`;"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                warps.add(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for warp data.", new Throwable[0]);
        }
        return warps;
    }

    @Override
    public List<Home> getPublicHomes() {
        ArrayList<Home> userHomes = new ArrayList<Home>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%homes_table%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`, `name`,\n    `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`,\n    `server_name`, `public`\nFROM `%homes_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%homes_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nINNER JOIN `%players_table%`\n    ON `%homes_table%`.`owner_uuid`=`%players_table%`.`uuid`\nWHERE `public`=true\nORDER BY `name`;"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                userHomes.add(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), User.of(UUID.fromString(resultSet.getString("owner_uuid")), resultSet.getString("owner_username")), resultSet.getBoolean("public")));
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the database for public home data", new Throwable[0]);
        }
        return userHomes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Home> getHome(@NotNull User user, @NotNull String homeName, boolean caseInsensitive) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%homes_table%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%homes_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%homes_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nINNER JOIN `%players_table%`\n    ON `%homes_table%`.`owner_uuid`=`%players_table%`.`uuid`\nWHERE `owner_uuid`=?\nAND ((? AND UPPER(`name`) LIKE UPPER(?)) OR (`name`=?))"));){
            statement.setString(1, user.getUuid().toString());
            statement.setBoolean(2, caseInsensitive);
            statement.setString(3, homeName);
            statement.setString(4, homeName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Home> optional = Optional.of(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), user, resultSet.getBoolean("public")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a player's home", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Home> getHome(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%homes_table%`.`uuid` AS `home_uuid`, `owner_uuid`, `username` AS `owner_username`,\n    `name`, `description`, `tags`, `timestamp`, `x`, `y`, `z`, `yaw`, `pitch`, `world_name`,\n    `world_uuid`, `server_name`, `public`\nFROM `%homes_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%homes_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nINNER JOIN `%players_table%`\n    ON `%homes_table%`.`owner_uuid`=`%players_table%`.`uuid`\nWHERE `%homes_table%`.`uuid`=?;"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Home> optional = Optional.of(Home.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("home_uuid")), User.of(UUID.fromString(resultSet.getString("owner_uuid")), resultSet.getString("owner_username")), resultSet.getBoolean("public")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a player's home by uuid", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Warp> getWarp(@NotNull String warpName, boolean caseInsensitive) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%warps_table%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warps_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%warps_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nAND ((? AND UPPER(`name`) LIKE UPPER(?)) OR (`name`=?))"));){
            statement.setBoolean(1, caseInsensitive);
            statement.setString(2, warpName);
            statement.setString(3, warpName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Warp> optional = Optional.of(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a server warp", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Warp> getWarp(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `%warps_table%`.`uuid` AS `warp_uuid`, `name`, `description`, `tags`, `timestamp`,\n    `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%warps_table%`\nINNER JOIN `%saved_positions_table%`\n    ON `%warps_table%`.`saved_position_id`=`%saved_positions_table%`.`id`\nINNER JOIN `%positions_table%`\n    ON `%saved_positions_table%`.`position_id`=`%positions_table%`.`id`\nWHERE `%warps_table%`.uuid=?;"));){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Warp> optional = Optional.of(Warp.from(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"), PositionMeta.from(resultSet.getString("name"), resultSet.getString("description"), resultSet.getTimestamp("timestamp").toInstant(), resultSet.getString("tags")), UUID.fromString(resultSet.getString("warp_uuid"))));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query a server warp", e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Teleport> getCurrentTeleport(@NotNull OnlineUser onlineUser) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`, `type`\nFROM `%teleports_table%`\nINNER JOIN `%positions_table%` ON `%teleports_table%`.`destination_id` = `%positions_table%`.`id`\nWHERE `player_uuid`=?"));){
            statement.setString(1, onlineUser.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Teleport> optional = Optional.of(Teleport.builder(this.plugin).teleporter(onlineUser).target(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name"))).type(Teleport.Type.getTeleportType(resultSet.getInt("type")).orElse(Teleport.Type.TELEPORT)).updateLastPosition(false).toTeleport());
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the current teleport of " + onlineUser.getUsername(), e);
            return Optional.empty();
        }
        catch (TeleportationException e) {
            e.displayMessage(onlineUser, new String[0]);
        }
        return Optional.empty();
    }

    @Override
    public void updateUserData(@NotNull SavedUser savedUser) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("UPDATE `%players_table%`\nSET `home_slots`=?, `ignoring_requests`=?\nWHERE `uuid`=?"));){
            statement.setInt(1, savedUser.getHomeSlots());
            statement.setBoolean(2, savedUser.isIgnoringTeleports());
            statement.setString(3, savedUser.getUserUuid().toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update user data for " + savedUser.getUsername(), e);
        }
    }

    @Override
    public void setCurrentTeleport(@NotNull User user, @Nullable Teleport teleport) {
        block21: {
            try (Connection connection = this.getConnection();){
                try (PreparedStatement deleteStatement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `id`=(\n    SELECT `destination_id`\n    FROM `%teleports_table%`\n    WHERE `%teleports_table%`.`player_uuid`=?\n);"));){
                    deleteStatement.setString(1, user.getUuid().toString());
                    deleteStatement.executeUpdate();
                }
                if (teleport == null) break block21;
                try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%teleports_table%` (`player_uuid`, `destination_id`, `type`)\nVALUES (?,?,?);"));){
                    statement.setString(1, user.getUuid().toString());
                    statement.setInt(2, this.setPosition((Position)teleport.getTarget(), connection));
                    statement.setInt(3, teleport.getType().getTypeId());
                    statement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to clear the current teleport of " + user.getUsername(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getLastPosition(@NotNull User user) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.`last_position` = `%positions_table%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the last teleport position of " + user.getUsername(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setLastPosition(@NotNull User user, @NotNull Position position) {
        block21: {
            try (Connection connection = this.getConnection();
                 PreparedStatement queryStatement = connection.prepareStatement(this.formatStatementTables("SELECT `last_position`\nFROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.last_position = `%positions_table%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    this.updatePosition(resultSet.getInt("last_position"), position, connection);
                    break block21;
                }
                try (PreparedStatement updateStatement = connection.prepareStatement(this.formatStatementTables("UPDATE `%players_table%`\nSET `last_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the last position of " + user.getUsername(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getOfflinePosition(@NotNull User user) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.`offline_position` = `%positions_table%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the offline position of " + user.getUsername(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setOfflinePosition(@NotNull User user, @NotNull Position position) {
        block21: {
            try (Connection connection = this.getConnection();
                 PreparedStatement queryStatement = connection.prepareStatement(this.formatStatementTables("SELECT `offline_position` FROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.`offline_position` = `%positions_table%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    this.updatePosition(resultSet.getInt("offline_position"), position, connection);
                    break block21;
                }
                try (PreparedStatement updateStatement = connection.prepareStatement(this.formatStatementTables("UPDATE `%players_table%`\nSET `offline_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the offline position of " + user.getUsername(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Position> getRespawnPosition(@NotNull User user) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `x`, `y`, `z`, `yaw`, `pitch`, `world_name`, `world_uuid`, `server_name`\nFROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.`respawn_position` = `%positions_table%`.`id`\nWHERE `uuid`=?"));){
            statement.setString(1, user.getUuid().toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            Optional<Position> optional = Optional.of(Position.at(resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), World.from(resultSet.getString("world_name"), UUID.fromString(resultSet.getString("world_uuid"))), resultSet.getString("server_name")));
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to query the respawn position of " + user.getUsername(), e);
        }
        return Optional.empty();
    }

    @Override
    public void setRespawnPosition(@NotNull User user, @Nullable Position position) {
        block28: {
            try (Connection connection = this.getConnection();
                 PreparedStatement queryStatement = connection.prepareStatement(this.formatStatementTables("SELECT `respawn_position` FROM `%players_table%`\nINNER JOIN `%positions_table%` ON `%players_table%`.respawn_position = `%positions_table%`.`id`\nWHERE `uuid`=?;"));){
                queryStatement.setString(1, user.getUuid().toString());
                ResultSet resultSet = queryStatement.executeQuery();
                if (resultSet.next()) {
                    if (position == null) {
                        try (PreparedStatement deleteStatement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `id`=(\n    SELECT `respawn_position`\n    FROM `%players_table%`\n    WHERE `%players_table%`.`uuid`=?\n);"));){
                            deleteStatement.setString(1, user.getUuid().toString());
                            deleteStatement.executeUpdate();
                            break block28;
                        }
                    }
                    this.updatePosition(resultSet.getInt("respawn_position"), position, connection);
                    break block28;
                }
                if (position == null) break block28;
                try (PreparedStatement updateStatement = connection.prepareStatement(this.formatStatementTables("UPDATE `%players_table%`\nSET `respawn_position`=?\nWHERE `uuid`=?;"));){
                    updateStatement.setInt(1, this.setPosition(position, connection));
                    updateStatement.setString(2, user.getUuid().toString());
                    updateStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set the respawn position of " + user.getUsername(), e);
            }
        }
    }

    @Override
    public void saveHome(@NotNull Home home) {
        this.getHome(home.getUuid()).ifPresentOrElse(presentHome -> {
            try (Connection connection = this.getConnection();){
                try (PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `saved_position_id` FROM `%homes_table%`\nWHERE `uuid`=?;"));){
                    statement.setString(1, home.getUuid().toString());
                    ResultSet resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        this.updateSavedPosition(resultSet.getInt("saved_position_id"), home, connection);
                    }
                }
                statement = connection.prepareStatement(this.formatStatementTables("UPDATE `%homes_table%`\nSET `public`=?\nWHERE `uuid`=?;"));
                try {
                    statement.setBoolean(1, home.isPublic());
                    statement.setString(2, home.getUuid().toString());
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to update a home in the database for " + home.getOwner().getUsername(), e);
            }
        }, () -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%homes_table%` (`uuid`, `saved_position_id`, `owner_uuid`, `public`)\nVALUES (?,?,?,?);"));){
                statement.setString(1, home.getUuid().toString());
                statement.setInt(2, this.setSavedPosition(home, connection));
                statement.setString(3, home.getOwner().getUuid().toString());
                statement.setBoolean(4, home.isPublic());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to set a home to the database for " + home.getOwner().getUsername(), e);
            }
        });
    }

    @Override
    public void saveWarp(@NotNull Warp warp) {
        this.getWarp(warp.getUuid()).ifPresentOrElse(presentWarp -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("SELECT `saved_position_id` FROM `%warps_table%`\nWHERE `uuid`=?;"));){
                statement.setString(1, warp.getUuid().toString());
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    this.updateSavedPosition(resultSet.getInt("saved_position_id"), warp, connection);
                }
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to update a warp in the database", e);
            }
        }, () -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("INSERT INTO `%warps_table%` (`uuid`, `saved_position_id`)\nVALUES (?,?);"));){
                statement.setString(1, warp.getUuid().toString());
                statement.setInt(2, this.setSavedPosition(warp, connection));
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.log(Level.SEVERE, "Failed to add a warp to the database", e);
            }
        });
    }

    @Override
    public void deleteHome(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id`=(\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id`=(\n        SELECT `saved_position_id`\n        FROM `%homes_table%`\n        WHERE `uuid`=?\n    )\n);"));){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a home from the database", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteAllHomes(@NotNull User user) {
        try (Connection connection = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%homes_table%`\n        WHERE `owner_uuid`=?\n    )\n);"));
                try {
                    statement.setString(1, user.getUuid().toString());
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all homes for " + user.getUsername() + " from the database", e);
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteAllHomes(@NotNull String worldName, @NotNull String serverName) {
        try (Connection connection = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%homes_table%`\n        WHERE `world_name`=?\n        AND `server_name`=?\n    )\n);"));
                try {
                    statement.setString(1, worldName);
                    statement.setString(2, serverName);
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete homes in the world " + worldName + " on the server " + serverName + " from the database", e);
            return 0;
        }
    }

    @Override
    public void deleteWarp(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id`=(\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id`=(\n        SELECT `saved_position_id`\n        FROM `%warps_table%`\n        WHERE `uuid`=?\n    )\n);"));){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete a warp from the database", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteAllWarps() {
        try (Connection connection = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%warps_table%`\n    )\n);"));
                try {
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all warps from the database", e);
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteAllWarps(@NotNull String worldName, @NotNull String serverName) {
        try (Connection connection = this.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.formatStatementTables("DELETE FROM `%positions_table%`\nWHERE `%positions_table%`.`id` IN (\n    SELECT `position_id`\n    FROM `%saved_positions_table%`\n    WHERE `%saved_positions_table%`.`id` IN (\n        SELECT `saved_position_id`\n        FROM `%warps_table%`\n        WHERE `world_name`=?\n        AND `server_name`=?\n    )\n);"));
                try {
                    statement.setString(1, worldName);
                    statement.setString(2, serverName);
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete warps in the world " + worldName + " on the server " + serverName + " from the database", e);
            return 0;
        }
    }

    @Override
    public void terminate() {
        if (this.connectionPool != null) {
            this.connectionPool.dispose();
        }
    }
}

