/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.database;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public abstract class Database {
    protected final HuskHomes plugin;

    protected final String[] getSchemaStatements(@NotNull String schemaFileName) throws IOException {
        return this.formatStatementTables(new String(Objects.requireNonNull(this.plugin.getResource(schemaFileName)).readAllBytes(), StandardCharsets.UTF_8)).split(";");
    }

    protected final String formatStatementTables(@NotNull String sql) {
        return sql.replaceAll("%positions_table%", this.plugin.getSettings().getTableName(Table.POSITION_DATA)).replaceAll("%players_table%", this.plugin.getSettings().getTableName(Table.PLAYER_DATA)).replaceAll("%cooldowns_table%", this.plugin.getSettings().getTableName(Table.PLAYER_COOLDOWNS_DATA)).replaceAll("%teleports_table%", this.plugin.getSettings().getTableName(Table.TELEPORT_DATA)).replaceAll("%saved_positions_table%", this.plugin.getSettings().getTableName(Table.SAVED_POSITION_DATA)).replaceAll("%homes_table%", this.plugin.getSettings().getTableName(Table.HOME_DATA)).replaceAll("%warps_table%", this.plugin.getSettings().getTableName(Table.WARP_DATA));
    }

    protected Database(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    public abstract void initialize() throws IllegalStateException;

    protected abstract int setPosition(@NotNull Position var1, @NotNull Connection var2) throws SQLException;

    @ApiStatus.Internal
    protected abstract void updatePosition(int var1, @NotNull Position var2, @NotNull Connection var3) throws SQLException;

    @ApiStatus.Internal
    protected abstract int setSavedPosition(@NotNull SavedPosition var1, @NotNull Connection var2) throws SQLException;

    @ApiStatus.Internal
    protected abstract void updateSavedPosition(int var1, @NotNull SavedPosition var2, @NotNull Connection var3) throws SQLException;

    public abstract void ensureUser(@NotNull User var1);

    public abstract Optional<SavedUser> getUserDataByName(@NotNull String var1);

    public abstract Optional<SavedUser> getUserData(@NotNull UUID var1);

    public abstract void deleteUserData(@NotNull UUID var1);

    public abstract Optional<Instant> getCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2);

    public abstract void setCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2, @NotNull Instant var3);

    public abstract void removeCooldown(@NotNull TransactionResolver.Action var1, @NotNull User var2);

    public abstract List<Home> getHomes(@NotNull User var1);

    public abstract List<Warp> getWarps();

    @NotNull
    public final List<Warp> getLocalWarps(@NotNull HuskHomes plugin) {
        return this.getWarps().stream().filter(warp -> warp.getServer().equals(plugin.getServerName())).collect(Collectors.toList());
    }

    public abstract List<Home> getPublicHomes();

    @NotNull
    public final List<Home> getLocalPublicHomes(@NotNull HuskHomes plugin) {
        return this.getPublicHomes().stream().filter(home -> home.getServer().equals(plugin.getServerName())).collect(Collectors.toList());
    }

    public final Optional<Home> getHome(@NotNull User user, @NotNull String homeName) {
        return this.getHome(user, homeName, this.plugin.getSettings().caseInsensitiveNames());
    }

    public abstract Optional<Home> getHome(@NotNull User var1, @NotNull String var2, boolean var3);

    public abstract Optional<Home> getHome(@NotNull UUID var1);

    public final Optional<Warp> getWarp(@NotNull String warpName) {
        return this.getWarp(warpName, this.plugin.getSettings().caseInsensitiveNames());
    }

    public abstract Optional<Warp> getWarp(@NotNull String var1, boolean var2);

    public abstract Optional<Warp> getWarp(@NotNull UUID var1);

    public abstract Optional<Teleport> getCurrentTeleport(@NotNull OnlineUser var1);

    public abstract void updateUserData(@NotNull SavedUser var1);

    public abstract void setCurrentTeleport(@NotNull User var1, @Nullable Teleport var2);

    public final void clearCurrentTeleport(@NotNull User user) {
        this.setCurrentTeleport(user, null);
    }

    public abstract Optional<Position> getLastPosition(@NotNull User var1);

    public abstract void setLastPosition(@NotNull User var1, @NotNull Position var2);

    public abstract Optional<Position> getOfflinePosition(@NotNull User var1);

    public abstract void setOfflinePosition(@NotNull User var1, @NotNull Position var2);

    public abstract Optional<Position> getRespawnPosition(@NotNull User var1);

    public abstract void setRespawnPosition(@NotNull User var1, @Nullable Position var2);

    public abstract void saveHome(@NotNull Home var1);

    public abstract void saveWarp(@NotNull Warp var1);

    public abstract void deleteHome(@NotNull UUID var1);

    public abstract int deleteAllHomes(@NotNull User var1);

    public abstract int deleteAllHomes(@NotNull String var1, @NotNull String var2);

    public abstract void deleteWarp(@NotNull UUID var1);

    public abstract int deleteAllWarps();

    public abstract int deleteAllWarps(@NotNull String var1, @NotNull String var2);

    public abstract void terminate();

    public static enum Table {
        PLAYER_DATA("huskhomes_users"),
        PLAYER_COOLDOWNS_DATA("huskhomes_user_cooldowns"),
        POSITION_DATA("huskhomes_position_data"),
        SAVED_POSITION_DATA("huskhomes_saved_positions"),
        HOME_DATA("huskhomes_homes"),
        WARP_DATA("huskhomes_warps"),
        TELEPORT_DATA("huskhomes_teleports");

        private final String defaultName;

        private Table(String defaultName) {
            this.defaultName = defaultName;
        }

        @NotNull
        public String getDefaultName() {
            return this.defaultName;
        }

        @NotNull
        public static Map<String, String> getConfigMap() {
            return Arrays.stream(Table.values()).collect(Collectors.toMap(table -> table.name().toLowerCase(Locale.ENGLISH), Table::getDefaultName));
        }
    }

    public static enum Type {
        MYSQL("MySQL"),
        MARIADB("MariaDB"),
        SQLITE("SQLite"),
        H2("H2");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

