/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.util.UUID;
import net.william278.huskhomes.libraries.annotaml.YamlFile;
import net.william278.huskhomes.libraries.annotaml.YamlKey;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    Server /spawn location    \u2503\n\u2503 Edit in-game using /setspawn \u2503\n\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b")
public class Spawn {
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    @YamlKey(value="world_name")
    public String worldName;
    @YamlKey(value="world_uuid")
    public String worldUuid;

    @NotNull
    public Position getPosition(@NotNull String server) {
        return Position.at(this.x, this.y, this.z, this.yaw, this.pitch, World.from(this.worldName, UUID.fromString(this.worldUuid)), server);
    }

    public Spawn(@NotNull Location location) {
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.worldName = location.getWorld().getName();
        this.worldUuid = location.getWorld().getUuid().toString();
    }

    public Spawn() {
    }
}

