/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.libraries.annotaml.YamlComment;
import net.william278.huskhomes.libraries.annotaml.YamlFile;
import net.william278.huskhomes.libraries.annotaml.YamlKey;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.util.TransactionResolver;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503       HuskHomes Config       \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/huskhomes/\n\u2523\u2578 Config Help: https://william278.net/docs/huskhomes/config-files/\n\u2517\u2578 Documentation: https://william278.net/docs/huskhomes/")
public class Settings {
    @YamlComment(value="Locale of the default language file to use. Docs: https://william278.net/docs/huskhomes/translations")
    @YamlKey(value="language")
    private String language = "en-gb";
    @YamlComment(value="Whether to automatically check for plugin updates on startup")
    @YamlKey(value="check_for_updates")
    private boolean checkForUpdates = true;
    @YamlComment(value="Type of database to use (SQLITE, H2, MYSQL or MARIADB)")
    @YamlKey(value="database.type")
    private Database.Type databaseType = Database.Type.SQLITE;
    @YamlComment(value="Specify credentials here if you are using MYSQL or MARIADB as your database type")
    @YamlKey(value="database.mysql.credentials.host")
    private String mySqlHost = "localhost";
    @YamlKey(value="database.mysql.credentials.port")
    private int mySqlPort = 3306;
    @YamlKey(value="database.mysql.credentials.database")
    private String mySqlDatabase = "HuskHomes";
    @YamlKey(value="database.mysql.credentials.username")
    private String mySqlUsername = "root";
    @YamlKey(value="database.mysql.credentials.password")
    private String mySqlPassword = "pa55w0rd";
    @YamlKey(value="database.mysql.credentials.parameters")
    private String mySqlConnectionParameters = "?autoReconnect=true&useSSL=false&useUnicode=true&characterEncoding=UTF-8";
    @YamlComment(value="MYSQL / MARIADB database Hikari connection pool properties. Don't modify this unless you know what you're doing!")
    @YamlKey(value="database.mysql.connection_pool.size")
    private int mySqlConnectionPoolSize = 12;
    @YamlKey(value="database.mysql.connection_pool.idle")
    private int mySqlConnectionPoolIdle = 12;
    @YamlKey(value="database.mysql.connection_pool.lifetime")
    private long mySqlConnectionPoolLifetime = 1800000L;
    @YamlKey(value="database.mysql.connection_pool.keepalive")
    private long mySqlConnectionPoolKeepAlive = 30000L;
    @YamlKey(value="database.mysql.connection_pool.timeout")
    private long mySqlConnectionPoolTimeout = 20000L;
    @YamlComment(value="Names of tables to use on your database. Don't modify this unless you know what you're doing!")
    @YamlKey(value="database.table_names")
    private TreeMap<String, String> tableNames = new TreeMap<String, String>(Database.Table.getConfigMap());
    @YamlComment(value="The maximum homes a user can create. Override with the huskhomes.max_homes.<number> permission.")
    @YamlKey(value="general.max_homes")
    private int maxHomes = 10;
    @YamlComment(value="The maximum public homes a user can create. Override with the huskhomes.max_public_homes.<number> permission.")
    @YamlKey(value="general.max_public_homes")
    private int maxPublicHomes = 10;
    @YamlComment(value="Whether permission limits (i.e. huskhomes.max_homes.<number>) should stack if the user inherits multiple nodes.")
    @YamlKey(value="general.stack_permission_limits")
    private boolean stackPermissionLimits = false;
    @YamlComment(value="Whether users require a permission (huskhomes.command.warp.<warp_name>) to use warps")
    @YamlKey(value="general.permission_restrict_warps")
    private boolean permissionRestrictWarps = false;
    @YamlComment(value="Whether running /sethome <name> or /setwarp <name> when a home/warp already exists should overwrite.")
    @YamlKey(value="general.overwrite_existing_homes_warps")
    private boolean overwriteExistingHomesWarps = true;
    @YamlComment(value="How long a player has to stand still and not take damage for when teleporting (in seconds) ")
    @YamlKey(value="general.teleport_warmup_time")
    private int teleportWarmupTime = 5;
    @YamlComment(value="Where the teleport warmup timer should display (CHAT, ACTION_BAR, TITLE, SUBTITLE or NONE)")
    @YamlKey(value="general.teleport_warmup_display")
    private Locales.DisplaySlot teleportWarmupDisplay = Locales.DisplaySlot.ACTION_BAR;
    @YamlComment(value="How long before received teleport requests expire (in seconds)")
    @YamlKey(value="general.teleport_request_expiry_time")
    private int teleportRequestExpiryTime = 60;
    @YamlComment(value="Whether /tpahere should use the location of the sender when sent. Docs: https://william278.net/docs/huskhomes/strict-tpahere/")
    @YamlKey(value="general.strict_tpa_here_requests")
    private boolean strictTpaHereRequests = true;
    @YamlComment(value="Whether home or warp names should be case insensitive (i.e. allow /home HomeOne and /home homeone)")
    @YamlKey(value="general.case_insensitive_names")
    private boolean caseInsensitiveNames = false;
    @YamlComment(value="Whether home and warp names should be restricted by a regex.Set this to false to allow full UTF-8 names (i.e. allow /home \u4f60\u597d).")
    @YamlKey(value="general.restrict_names")
    private boolean restrictNames = true;
    @YamlComment(value="Regex which home and warp names must match. Names have a max length of 16 characters")
    @YamlKey(value="general.name_regex")
    private String nameRegex = "[a-zA-Z0-9-_]*";
    @YamlComment(value="Whether home/warp descriptions should be restricted. Set this to true to restrict UTF-8 usage.")
    @YamlKey(value="general.restrict_descriptions")
    private boolean restrictDescriptions = false;
    @YamlComment(value="Regex which home and warp descriptions must match. A hard max length of 256 characters is enforced")
    @YamlKey(value="general.description_regex")
    private String descriptionRegex = "\\A\\p{ASCII}*\\z";
    @YamlComment(value="Whether /back should work to teleport the user to where they died")
    @YamlKey(value="general.back_command_return_by_death")
    private boolean backCommandReturnByDeath = true;
    @YamlComment(value="Whether /back should work with other plugins that use the PlayerTeleportEvent (can cause conflicts)")
    @YamlKey(value="general.back_command_save_teleport_event")
    private boolean backCommandSaveOnTeleportEvent = false;
    @YamlComment(value="How many items should be displayed per-page in chat menu lists")
    @YamlKey(value="general.list_items_per_page")
    private int listItemsPerPage = 12;
    @YamlComment(value="Whether teleportation should be carried out asynchronously (ensuring chunks load before teleporting)")
    @YamlKey(value="general.asynchronous_teleports")
    private boolean asynchronousTeleports = true;
    @YamlComment(value="Whether to play sound effects")
    @YamlKey(value="general.play_sound_effects")
    private boolean playSoundEffects = true;
    @YamlComment(value="Which sound effects to play for various actions")
    @YamlKey(value="general.sound_effects")
    private TreeMap<String, String> soundEffects = new TreeMap<String, String>(SoundEffectAction.getConfigMap());
    @YamlComment(value="Whether to provide modern, rich TAB suggestions for commands (if available)")
    @YamlKey(value="general.brigadier_tab_completion")
    private boolean brigadierTabCompletion = true;
    @YamlComment(value="Enable teleporting across your proxy network. Requires database type to be MYSQL")
    @YamlKey(value="cross_server.enabled")
    private boolean crossServer = false;
    @YamlComment(value="The type of message broker to use for cross-server communication. Options: PLUGIN_MESSAGE, REDIS")
    @YamlKey(value="cross_server.messenger_type")
    private Broker.Type messageBrokerType = Broker.Type.PLUGIN_MESSAGE;
    @YamlComment(value="Specify a common ID for grouping servers running HuskHomes on your proxy. Don't modify this unless you know what you're doing!")
    @YamlKey(value="cross_server.cluster_id")
    private String clusterId = "";
    @YamlComment(value="Define a single global /spawn for your network via a warp. Docs: https://william278.net/docs/huskhomes/global-spawn/")
    @YamlKey(value="cross_server.global_spawn.enabled")
    private boolean globalSpawn = false;
    @YamlComment(value="The name of the warp to use as the global spawn.")
    @YamlKey(value="cross_server.global_spawn.warp_name")
    private String globalSpawnName = "Spawn";
    @YamlComment(value="Whether player respawn positions should work cross-server. Docs: https://william278.net/docs/huskhomes/global-respawning/")
    @YamlKey(value="cross_server.global_respawning")
    private boolean globalRespawning = false;
    @YamlComment(value="Specify credentials here if you are using REDIS as your messenger_type. Docs: https://william278.net/docs/huskhomes/redis-support/")
    @YamlKey(value="cross_server.redis_credentials.host")
    private String redisHost = "localhost";
    @YamlKey(value="cross_server.redis_credentials.port")
    private int redisPort = 6379;
    @YamlKey(value="cross_server.redis_credentials.password")
    private String redisPassword = "";
    @YamlKey(value="cross_server.redis_credentials.use_ssl")
    private boolean redisUseSsl = false;
    @YamlComment(value="Radius around the spawn point in which players cannot be random teleported to")
    @YamlKey(value="rtp.radius")
    private int rtpRadius = 5000;
    @YamlComment(value="Radius of the spawn area in which players cannot be random teleported to")
    @YamlKey(value="rtp.spawn_radius")
    private int rtpSpawnRadius = 500;
    @YamlComment(value="Mean of the normal distribution used to calculate the distance from the center of the world")
    @YamlKey(value="rtp.distribution_mean")
    private float rtpDistributionMean = 0.75f;
    @YamlComment(value="Standard deviation of the normal distribution for distributing players randomly")
    @YamlKey(value="rtp.distribution_deviation")
    private float rtpDistributionStandardDeviation = 2.0f;
    @YamlComment(value="List of worlds in which /rtp is disabled. Please note that /rtp does not work well in the nether.")
    @YamlKey(value="rtp.restricted_worlds")
    private List<String> rtpRestrictedWorlds = List.of("world_nether", "world_the_end");
    @YamlComment(value="Whether to apply a cooldown between performing certain actions")
    @YamlKey(value="cooldowns.enabled")
    private boolean cooldowns = true;
    @YamlComment(value="Set a cooldown between performing actions (in seconds). Docs: https://william278.net/docs/huskhomes/cooldowns/")
    @YamlKey(value="cooldowns.cooldown_times")
    private TreeMap<String, Integer> cooldownTimes = new TreeMap<String, Integer>(TransactionResolver.Action.getCooldownsConfigMap());
    @YamlComment(value="Enable economy plugin integration (requires Vault)")
    @YamlKey(value="economy.enabled")
    private boolean economy = false;
    @YamlComment(value="Specify how many homes players can set for free, before they need to pay for more slots")
    @YamlKey(value="economy.free_home_slots")
    private int freeHomeSlots = 5;
    @YamlComment(value="Charge money for perform certain actions. Docs: https://william278.net/docs/huskhomes/economy-hook/")
    @YamlKey(value="economy.costs")
    private TreeMap<String, Double> economyCosts = new TreeMap<String, Double>(TransactionResolver.Action.getEconomyCostsConfigMap());
    @YamlComment(value="Display public homes/warps on your Dynmap, BlueMap or Pl3xMap. Docs: https://william278.net/docs/huskhomes/map-hooks")
    @YamlKey(value="map_hook.enabled")
    private boolean doMapHook = true;
    @YamlComment(value="Show public homes on the web map")
    @YamlKey(value="map_hook.show_public_homes")
    private boolean publicHomesOnMap = true;
    @YamlComment(value="Show warps on the web map")
    @YamlKey(value="map_hook.show_warps")
    private boolean warpsOnMap = true;
    @YamlComment(value="List of commands to disable (e.g. ['/home', '/warp'] to disable /home and /warp)")
    @YamlKey(value="disabled_commands")
    private List<String> disabledCommands = Collections.emptyList();

    private Settings() {
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public boolean doCheckForUpdates() {
        return this.checkForUpdates;
    }

    @NotNull
    public Database.Type getDatabaseType() {
        return this.databaseType;
    }

    @NotNull
    public String getMySqlHost() {
        return this.mySqlHost;
    }

    public int getMySqlPort() {
        return this.mySqlPort;
    }

    @NotNull
    public String getMySqlDatabase() {
        return this.mySqlDatabase;
    }

    @NotNull
    public String getMySqlUsername() {
        return this.mySqlUsername;
    }

    @NotNull
    public String getMySqlPassword() {
        return this.mySqlPassword;
    }

    @NotNull
    public String getMySqlConnectionParameters() {
        return this.mySqlConnectionParameters;
    }

    public int getMySqlConnectionPoolSize() {
        return this.mySqlConnectionPoolSize;
    }

    public int getMySqlConnectionPoolIdle() {
        return this.mySqlConnectionPoolIdle;
    }

    public long getMySqlConnectionPoolLifetime() {
        return this.mySqlConnectionPoolLifetime;
    }

    public long getMySqlConnectionPoolKeepAlive() {
        return this.mySqlConnectionPoolKeepAlive;
    }

    public long getMySqlConnectionPoolTimeout() {
        return this.mySqlConnectionPoolTimeout;
    }

    @NotNull
    public TreeMap<String, String> getTableNames() {
        TreeMap<String, String> tableNames = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tableNames.putAll(this.tableNames);
        return tableNames;
    }

    @NotNull
    public String getTableName(@NotNull Database.Table table) {
        return Optional.ofNullable(this.getTableNames().get(table.name())).orElse(table.getDefaultName());
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getMaxPublicHomes() {
        return this.maxPublicHomes;
    }

    public boolean doStackPermissionLimits() {
        return this.stackPermissionLimits;
    }

    public boolean doPermissionRestrictWarps() {
        return this.permissionRestrictWarps;
    }

    public boolean doOverwriteExistingHomesWarps() {
        return this.overwriteExistingHomesWarps;
    }

    public int getTeleportWarmupTime() {
        return this.teleportWarmupTime;
    }

    @NotNull
    public Locales.DisplaySlot getTeleportWarmupDisplay() {
        return this.teleportWarmupDisplay;
    }

    public int getTeleportRequestExpiryTime() {
        return this.teleportRequestExpiryTime;
    }

    public boolean doStrictTpaHereRequests() {
        return this.strictTpaHereRequests;
    }

    public boolean caseInsensitiveNames() {
        return this.caseInsensitiveNames;
    }

    public boolean doRestrictNames() {
        return this.restrictNames;
    }

    @NotNull
    public String getNameRegex() {
        return this.nameRegex;
    }

    public boolean doRestrictDescriptions() {
        return this.restrictDescriptions;
    }

    @NotNull
    public String getDescriptionRegex() {
        return this.descriptionRegex;
    }

    public boolean doBackCommandReturnByDeath() {
        return this.backCommandReturnByDeath;
    }

    public boolean doBackCommandSaveOnTeleportEvent() {
        return this.backCommandSaveOnTeleportEvent;
    }

    public int getListItemsPerPage() {
        return this.listItemsPerPage;
    }

    public boolean doAsynchronousTeleports() {
        return this.asynchronousTeleports;
    }

    public boolean doPlaySoundEffects() {
        return this.playSoundEffects;
    }

    @NotNull
    public TreeMap<String, String> getSoundEffects() {
        TreeMap<String, String> soundEffects = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        soundEffects.putAll(this.soundEffects);
        return soundEffects;
    }

    public Optional<String> getSoundEffect(@NotNull SoundEffectAction action) {
        if (!this.doPlaySoundEffects()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getSoundEffects().get(action.name()));
    }

    public boolean doCrossServer() {
        return this.crossServer;
    }

    @NotNull
    public Broker.Type getBrokerType() {
        return this.messageBrokerType;
    }

    @NotNull
    public String getClusterId() {
        return this.clusterId;
    }

    public boolean isGlobalSpawn() {
        return this.globalSpawn;
    }

    @NotNull
    public String getGlobalSpawnName() {
        return this.globalSpawnName;
    }

    public boolean isGlobalRespawning() {
        return this.globalRespawning;
    }

    @NotNull
    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    @NotNull
    public String getRedisPassword() {
        return this.redisPassword;
    }

    public boolean useRedisSsl() {
        return this.redisUseSsl;
    }

    public int getRtpRadius() {
        return this.rtpRadius;
    }

    public int getRtpSpawnRadius() {
        return this.rtpSpawnRadius;
    }

    public float getRtpDistributionMean() {
        return this.rtpDistributionMean;
    }

    public float getRtpDistributionStandardDeviation() {
        return this.rtpDistributionStandardDeviation;
    }

    public boolean isWorldRtpRestricted(@NotNull World world) {
        String worldName = world.getName();
        String filteredName = worldName.startsWith("minecraft:") ? worldName.substring(10) : worldName;
        return this.rtpRestrictedWorlds.stream().map(name -> name.startsWith("minecraft:") ? name.substring(10) : name).anyMatch(name -> name.equalsIgnoreCase(filteredName));
    }

    public boolean doCooldowns() {
        return this.cooldowns;
    }

    @NotNull
    public TreeMap<String, Integer> getCooldownTimes() {
        TreeMap<String, Integer> cooldownTimes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        cooldownTimes.putAll(this.cooldownTimes);
        return cooldownTimes;
    }

    public long getCooldown(@NotNull TransactionResolver.Action action) {
        if (!this.doCooldowns()) {
            return 0L;
        }
        Integer cooldown = this.getCooldownTimes().get(action.name());
        if (cooldown != null && cooldown > 0) {
            return cooldown.intValue();
        }
        return 0L;
    }

    public boolean doEconomy() {
        return this.economy;
    }

    public int getFreeHomeSlots() {
        return this.freeHomeSlots;
    }

    @NotNull
    public TreeMap<String, Double> getEconomyCosts() {
        TreeMap<String, Double> economyCosts = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        economyCosts.putAll(this.economyCosts);
        return economyCosts;
    }

    public Optional<Double> getEconomyCost(@NotNull TransactionResolver.Action action) {
        if (!this.doEconomy()) {
            return Optional.empty();
        }
        Double cost = this.getEconomyCosts().get(action.name());
        if (cost != null && cost > 0.0) {
            return Optional.of(cost);
        }
        return Optional.empty();
    }

    public boolean doMapHook() {
        return this.doMapHook;
    }

    public boolean doPublicHomesOnMap() {
        return this.publicHomesOnMap;
    }

    public boolean doWarpsOnMap() {
        return this.warpsOnMap;
    }

    public boolean isCommandDisabled(Command type) {
        return this.disabledCommands.stream().anyMatch(disabled -> {
            String command = disabled.startsWith("/") ? disabled.substring(1) : disabled;
            return command.equalsIgnoreCase(type.getName()) || type.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(command));
        });
    }

    public boolean doBrigadierTabCompletion() {
        return this.brigadierTabCompletion;
    }

    public static enum SoundEffectAction {
        TELEPORTATION_COMPLETE("entity.enderman.teleport"),
        TELEPORTATION_WARMUP("block.note_block.banjo"),
        TELEPORTATION_CANCELLED("entity.item.break"),
        TELEPORT_REQUEST_RECEIVED("entity.experience_orb.pickup");

        private final String defaultEffect;

        private SoundEffectAction(String defaultEffect) {
            this.defaultEffect = defaultEffect;
        }

        @NotNull
        public static Map<String, String> getConfigMap() {
            return Arrays.stream(SoundEffectAction.values()).collect(Collectors.toMap(action -> action.name().toLowerCase(Locale.ENGLISH), action -> action.defaultEffect));
        }
    }
}

