/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.nio.file.Path;
import net.william278.huskhomes.libraries.annotaml.YamlFile;
import net.william278.huskhomes.libraries.annotaml.YamlKey;
import net.william278.huskhomes.libraries.annotations.NotNull;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503  HuskHomes Server ID config  \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 This file should contain the ID of this server as defined in your proxy config.\n\u2523\u2578 If you join it using /server alpha, then set it to 'alpha' (case-sensitive)\n\u2517\u2578 You only need to touch this if you're using cross-server mode.")
public class Server {
    @YamlKey(value="name")
    private String serverName = Server.getDefaultServerName();

    @NotNull
    public static String getDefaultServerName() {
        try {
            Path serverDirectory = Path.of(System.getProperty("user.dir"), new String[0]);
            return serverDirectory.getFileName().toString().trim();
        }
        catch (Exception e) {
            return "server";
        }
    }

    public Server(@NotNull String serverName) {
        this.serverName = serverName;
    }

    private Server() {
    }

    public boolean equals(@NotNull Object other) {
        if (other instanceof Server) {
            Server server = (Server)other;
            return server.getName().equalsIgnoreCase(this.getName());
        }
        return super.equals(other);
    }

    @NotNull
    public String getName() {
        return this.serverName;
    }
}

