/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paginedown.PaginatedList;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;

public class WarpListCommand
extends ListCommand {
    protected WarpListCommand(@NotNull HuskHomes plugin) {
        super("warplist", List.of("warps"), "[player] [page]", plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        int pageNumber = this.parseIntArg(args, 0).orElse(1);
        this.showWarpList(executor, pageNumber);
    }

    protected void showWarpList(@NotNull CommandUser executor, int pageNumber) {
        OnlineUser user;
        if (executor instanceof OnlineUser && this.cachedLists.containsKey((user = (OnlineUser)executor).getUuid())) {
            executor.sendMessage(((PaginatedList)this.cachedLists.get(user.getUuid())).getNearestValidPage(pageNumber));
            return;
        }
        List<Warp> warps = this.getItems(executor);
        this.plugin.fireEvent(this.plugin.getViewWarpListEvent(warps, executor), event -> this.generateList(executor, event.getWarps()).ifPresent(homeList -> {
            if (executor instanceof OnlineUser) {
                OnlineUser onlineUser = (OnlineUser)executor;
                this.cachedLists.put(onlineUser.getUuid(), homeList);
            }
            executor.sendMessage(homeList.getNearestValidPage(pageNumber));
        }));
    }

    private Optional<PaginatedList> generateList(@NotNull CommandUser executor, @NotNull List<Warp> warps) {
        if (warps.isEmpty()) {
            this.plugin.getLocales().getLocale("error_no_warps_set").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        PaginatedList warpList = PaginatedList.of(warps.stream().map(warp -> this.plugin.getLocales().getRawLocale("warp_list_item", Locales.escapeText(warp.getName()), warp.getSafeIdentifier(), Locales.escapeText(this.plugin.getLocales().wrapText(warp.getMeta().getDescription(), 40))).orElse(warp.getName())).sorted().collect(Collectors.toList()), this.plugin.getLocales().getBaseList(this.plugin.getSettings().getListItemsPerPage()).setHeaderFormat(this.plugin.getLocales().getRawLocale("warp_list_page_title", "%first_item_on_page_index%", "%last_item_on_page_index%", "%total_items%").orElse("")).setCommand("/huskhomes:warplist").build());
        return Optional.of(warpList);
    }

    @NotNull
    private List<Warp> getItems(@NotNull CommandUser executor) {
        List<Warp> warps = this.plugin.getDatabase().getWarps();
        if (this.plugin.getSettings().doPermissionRestrictWarps() && !executor.hasPermission(Warp.getWildcardPermission())) {
            warps = warps.stream().filter(warp -> executor.hasPermission(warp.getPermission())).toList();
        }
        return warps;
    }
}

