/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabProvider;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.teleport.Username;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;

public class TpCommand
extends Command
implements TabProvider {
    protected TpCommand(@NotNull HuskHomes plugin) {
        super("tp", List.of("tpo"), "[<player|position>] [target]", plugin);
        this.addAdditionalPermissions(Map.of("coordinates", true));
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        switch (args.length) {
            case 1: {
                if (!(executor instanceof OnlineUser)) {
                    this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
                    return;
                }
                OnlineUser user = (OnlineUser)executor;
                this.execute(executor, user, Target.username(args[0]), args);
                break;
            }
            case 2: {
                this.execute(executor, Teleportable.username(args[0]), Target.username(args[1]), args);
                break;
            }
            default: {
                Optional target;
                Position basePosition = this.getBasePosition(executor);
                Optional<Object> optional = target = executor.hasPermission(this.getPermission("coordinates")) ? this.parsePositionArgs(basePosition, args, 0) : Optional.empty();
                if (target.isPresent()) {
                    if (!(executor instanceof OnlineUser)) {
                        this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
                        return;
                    }
                    OnlineUser user = (OnlineUser)executor;
                    this.execute(executor, user, (Target)target.get(), args);
                    return;
                }
                Optional<Object> optional2 = target = executor.hasPermission(this.getPermission("coordinates")) ? this.parsePositionArgs(basePosition, args, 1) : Optional.empty();
                if (target.isPresent() && args.length >= 1) {
                    this.execute(executor, Teleportable.username(args[0]), (Target)target.get(), args);
                    return;
                }
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            }
        }
    }

    private void execute(@NotNull CommandUser executor, @NotNull Teleportable teleportable, @NotNull Target target, @NotNull String[] args) {
        String teleporterName;
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleportable).target(target);
        try {
            if (executor instanceof OnlineUser) {
                OnlineUser user = (OnlineUser)executor;
                builder.executor(user);
            }
            builder.toTeleport().execute();
        }
        catch (TeleportationException e) {
            e.displayMessage(executor, args);
            return;
        }
        if (teleportable instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)teleportable;
            v0 = user.getUsername();
        } else {
            v0 = teleporterName = ((Username)teleportable).name();
        }
        if (target instanceof Position) {
            Position position = (Position)target;
            this.plugin.getLocales().getLocale("teleporting_other_complete_position", teleporterName, Integer.toString((int)position.getX()), Integer.toString((int)position.getY()), Integer.toString((int)position.getZ())).ifPresent(executor::sendMessage);
        } else {
            this.plugin.getLocales().getLocale("teleporting_other_complete", teleporterName, ((Username)target).name()).ifPresent(executor::sendMessage);
        }
    }

    @Override
    @NotNull
    public final List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        Position relative = this.getBasePosition(user);
        boolean serveCoordinateCompletions = user.hasPermission(this.getPermission("coordinates"));
        switch (args.length) {
            case 0: 
            case 1: {
                ArrayList completions = new ArrayList();
                completions.addAll(serveCoordinateCompletions ? List.of("~", "~ ~", "~ ~ ~", Integer.toString((int)relative.getX()), (int)relative.getX() + " " + (int)relative.getY(), (int)relative.getX() + " " + (int)relative.getY() + " " + (int)relative.getZ()) : List.of());
                completions.addAll(this.plugin.getPlayerList(false));
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args.length == 1 ? args[0].toLowerCase() : "")).sorted().collect(Collectors.toList());
            }
            case 2: {
                ArrayList<Object> completions = new ArrayList<Object>();
                if (this.isCoordinate(args, 0)) {
                    completions.addAll(List.of("~", Integer.toString((int)relative.getY())));
                    completions.addAll(List.of("~ ~", (int)relative.getY() + " " + (int)relative.getZ()));
                } else {
                    completions.addAll(serveCoordinateCompletions ? List.of("~", "~ ~", "~ ~ ~", Integer.toString((int)relative.getX()), (int)relative.getX() + " " + (int)relative.getY(), (int)relative.getX() + " " + (int)relative.getY() + " " + (int)relative.getZ()) : List.of());
                    completions.addAll(this.plugin.getPlayerList(false));
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).sorted().collect(Collectors.toList());
            }
            case 3: {
                ArrayList<String> completions = new ArrayList<String>();
                if (this.isCoordinate(args, 1) && this.isCoordinate(args, 2)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getZ())));
                } else if (this.isCoordinate(args, 1)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getY())));
                    completions.addAll(List.of("~ ~", (int)relative.getY() + " " + (int)relative.getZ()));
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).sorted().collect(Collectors.toList());
            }
            case 4: {
                ArrayList<String> completions = new ArrayList<String>();
                if (this.isCoordinate(args, 1) && this.isCoordinate(args, 2) && !this.isCoordinate(args, 0)) {
                    if (!serveCoordinateCompletions) {
                        return completions;
                    }
                    completions.addAll(List.of("~", Integer.toString((int)relative.getZ())));
                }
                return completions.stream().filter(s -> s.toLowerCase().startsWith(args[3].toLowerCase())).sorted().collect(Collectors.toList());
            }
        }
        return List.of();
    }

    private boolean isCoordinate(@NotNull String[] args, int index) {
        return this.parseCoordinateArg(args, index, 0.0).isPresent();
    }
}

