/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.command.UserListTabProvider;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.manager.RequestsManager;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class TeleportRequestCommand
extends InGameCommand
implements UserListTabProvider {
    private final TeleportRequest.Type requestType;

    protected TeleportRequestCommand(@NotNull HuskHomes plugin, @NotNull TeleportRequest.Type requestType) {
        super(requestType == TeleportRequest.Type.TPA ? "tpa" : "tpahere", List.of(), "<player>", plugin);
        this.requestType = requestType;
    }

    @Override
    public void execute(@NotNull OnlineUser onlineUser, @NotNull String[] args) {
        RequestsManager manager = this.plugin.getManager().requests();
        if (manager.isIgnoringRequests(onlineUser)) {
            this.plugin.getLocales().getLocale("error_ignoring_teleport_requests").ifPresent(onlineUser::sendMessage);
            return;
        }
        Optional<String> optionalTarget = this.parseStringArg(args, 0);
        if (optionalTarget.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(onlineUser::sendMessage);
            return;
        }
        String target = optionalTarget.get();
        if (target.equalsIgnoreCase(onlineUser.getUsername())) {
            this.plugin.getLocales().getLocale("error_teleport_request_self").ifPresent(onlineUser::sendMessage);
            return;
        }
        if (!this.plugin.validateTransaction(onlineUser, TransactionResolver.Action.SEND_TELEPORT_REQUEST)) {
            return;
        }
        try {
            manager.sendTeleportRequest(onlineUser, target, this.requestType);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_player_not_found", target).ifPresent(onlineUser::sendMessage);
            return;
        }
        this.plugin.performTransaction(onlineUser, TransactionResolver.Action.SEND_TELEPORT_REQUEST);
        this.plugin.getLocales().getLocale((this.requestType == TeleportRequest.Type.TPA ? "tpa" : "tpahere") + "_request_sent", target).ifPresent(onlineUser::sendMessage);
    }
}

