/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.util.TransactionResolver;

public class SpawnCommand
extends Command {
    protected SpawnCommand(@NotNull HuskHomes plugin) {
        super("spawn", List.of(), "[player]", plugin);
        this.addAdditionalPermissions(Map.of("other", true));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<Position> spawn = this.plugin.getSpawn();
        if (spawn.isEmpty()) {
            this.plugin.getLocales().getLocale("error_spawn_not_set").ifPresent(executor::sendMessage);
            return;
        }
        Optional<Teleportable> optionalTeleporter = this.resolveTeleporter(executor, args);
        if (optionalTeleporter.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        this.teleportToSpawn(optionalTeleporter.get(), executor, spawn.get(), args);
    }

    public void teleportToSpawn(@NotNull Teleportable teleporter, @NotNull CommandUser executor, @NotNull Position spawn, @NotNull String[] args) {
        if (!executor.equals(teleporter) && !executor.hasPermission(this.getPermission("other"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleporter).actions(TransactionResolver.Action.SPAWN_TELEPORT).target(spawn);
        try {
            if (teleporter.equals(executor)) {
                builder.toTimedTeleport().execute();
            } else {
                builder.toTeleport().execute();
            }
        }
        catch (TeleportationException e) {
            e.displayMessage(executor, args);
        }
    }
}

