/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class SetSpawnCommand
extends InGameCommand {
    protected SetSpawnCommand(@NotNull HuskHomes plugin) {
        super("setspawn", List.of(), "", plugin);
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull OnlineUser executor, @NotNull String[] args) {
        Position position = executor.getPosition();
        try {
            if (this.plugin.getSettings().doCrossServer() && this.plugin.getSettings().isGlobalSpawn()) {
                String warpName = this.plugin.getSettings().getGlobalSpawnName();
                this.plugin.getManager().warps().createWarp(warpName, position, true);
                this.plugin.getLocales().getRawLocale("spawn_warp_default_description").ifPresent(description -> this.plugin.getManager().warps().setWarpDescription(warpName, (String)description));
            } else {
                this.plugin.setServerSpawn(position);
            }
        }
        catch (ValidationException e) {
            e.dispatchWarpError(executor, this.plugin, this.plugin.getSettings().getGlobalSpawnName());
            return;
        }
        this.plugin.getLocales().getLocale("set_spawn_success").ifPresent(executor::sendMessage);
    }
}

