/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabProvider;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public abstract class SavedPositionCommand<T extends SavedPosition>
extends Command
implements TabProvider {
    private final Class<T> positionType;
    protected final List<String> arguments;

    protected SavedPositionCommand(@NotNull String name, @NotNull List<String> aliases, @NotNull Class<T> positionType, @NotNull List<String> arguments, @NotNull HuskHomes plugin) {
        super(name, aliases, "<name>" + SavedPositionCommand.formatUsage(arguments), plugin);
        this.positionType = positionType;
        this.arguments = arguments;
        this.addAdditionalPermissions(Map.of("other", true));
    }

    @NotNull
    public String getOtherPermission() {
        return this.positionType == Home.class ? super.getPermission("other") : super.getPermission(new String[0]);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<String> name = this.parseStringArg(args, 0);
        if (name.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        Optional<SavedPosition> position = this.positionType == Home.class ? this.resolveHome(executor, name.get()) : this.resolveWarp(executor, name.get());
        position.ifPresent(p -> this.execute(executor, (SavedPosition)p, this.removeFirstArg(args)));
    }

    public abstract void execute(@NotNull CommandUser var1, @NotNull T var2, @NotNull String[] var3);

    private Optional<Home> resolveHome(@NotNull CommandUser executor, @NotNull String homeName) {
        if (homeName.contains(".")) {
            String ownerUsername = homeName.substring(0, homeName.indexOf("."));
            String ownerHome = homeName.substring(homeName.indexOf(".") + 1);
            if (ownerUsername.isBlank() || ownerHome.isBlank()) {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
            Optional<Home> optionalHome = this.plugin.getDatabase().getUserDataByName(ownerUsername).flatMap(owner -> this.resolveHomeByName(owner.getUser(), ownerHome));
            if (optionalHome.isEmpty()) {
                this.plugin.getLocales().getLocale(executor.hasPermission(this.getOtherPermission()) ? "error_home_invalid_other" : "error_public_home_invalid", ownerUsername, ownerHome).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
            Home home = (Home)optionalHome.get();
            if (executor instanceof OnlineUser) {
                OnlineUser user = (OnlineUser)executor;
                if (!(home.isPublic() || user.equals(home.getOwner()) || user.hasPermission(this.getOtherPermission()))) {
                    this.plugin.getLocales().getLocale("error_public_home_invalid", ownerUsername, ownerHome).ifPresent(executor::sendMessage);
                    return Optional.empty();
                }
            }
            return optionalHome;
        }
        if (executor instanceof OnlineUser) {
            OnlineUser owner2 = (OnlineUser)executor;
            Optional<Home> optionalHome = this.resolveHomeByName(owner2, homeName);
            if (optionalHome.isEmpty()) {
                this.plugin.getLocales().getLocale("error_home_invalid", homeName).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
            return optionalHome;
        }
        this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
        return Optional.empty();
    }

    private Optional<Home> resolveHomeByName(@NotNull User owner, @NotNull String homeName) {
        return this.plugin.getDatabase().getHome(owner, homeName).or(() -> {
            try {
                return this.plugin.getDatabase().getHome(UUID.fromString(homeName));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    private Optional<Warp> resolveWarp(@NotNull CommandUser executor, @NotNull String warpName) {
        Optional<Warp> warp = this.resolveWarpByName(warpName);
        if (warp.isEmpty()) {
            this.plugin.getLocales().getLocale("error_warp_invalid", warpName).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            if (this.plugin.getSettings().doPermissionRestrictWarps() && !user.hasPermission(Warp.getWildcardPermission()) && !user.hasPermission(Warp.getPermission(warpName))) {
                this.plugin.getLocales().getLocale("error_warp_invalid", warpName).ifPresent(executor::sendMessage);
                return Optional.empty();
            }
        }
        return warp;
    }

    private Optional<Warp> resolveWarpByName(@NotNull String warpName) {
        return this.plugin.getDatabase().getWarp(warpName).or(() -> {
            try {
                return this.plugin.getDatabase().getWarp(UUID.fromString(warpName));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    protected void teleport(@NotNull CommandUser executor, @NotNull Teleportable teleporter, @NotNull T position, TransactionResolver.Action ... actions) {
        if (!teleporter.equals(executor) && !executor.hasPermission(this.getPermission("other"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleporter).actions(actions).target((Target)position);
        try {
            if (executor.equals(teleporter)) {
                builder.toTimedTeleport().execute();
            } else {
                builder.toTeleport().execute();
            }
        }
        catch (TeleportationException e) {
            e.displayMessage(executor, teleporter.getUsername());
        }
    }

    @NotNull
    private static String formatUsage(List<String> arguments) {
        return arguments.size() > 0 ? " [" + String.join((CharSequence)"|", arguments) + "]" : "";
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull CommandUser executor, @NotNull String[] args) {
        if (this.positionType == Home.class) {
            return switch (args.length) {
                case 0, 1 -> {
                    if (args.length == 1 && args[0].contains(".")) {
                        if (executor.hasPermission(this.getOtherPermission())) {
                            yield this.filter(this.plugin.getManager().homes().getUserHomeIdentifiers(), args);
                        }
                        yield this.filter(this.plugin.getManager().homes().getUserHomeIdentifiers(), args);
                    }
                    if (executor instanceof OnlineUser) {
                        OnlineUser user = (OnlineUser)executor;
                        yield this.filter(this.plugin.getManager().homes().getUserHomes().get(user.getUsername()), args);
                    }
                    yield this.filter(this.plugin.getManager().homes().getUserHomeIdentifiers(), args);
                }
                case 2 -> this.filter(this.arguments.stream().toList(), args);
                default -> List.of();
            };
        }
        return switch (args.length) {
            case 0, 1 -> this.filter(this.plugin.getManager().warps().getUsableWarps(executor), args);
            case 2 -> this.filter(this.arguments.stream().toList(), args);
            default -> List.of();
        };
    }
}

