/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.UserListTabProvider;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class RtpCommand
extends Command
implements UserListTabProvider {
    protected RtpCommand(@NotNull HuskHomes plugin) {
        super("rtp", List.of(), "[player] [world]", plugin);
        this.addAdditionalPermissions(Map.of("other", true, "world", true));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional optionalTeleporter;
        Optional<Object> optional = args.length >= 1 ? this.plugin.getOnlineUser(args[0]) : (optionalTeleporter = executor instanceof OnlineUser ? Optional.of((OnlineUser)executor) : Optional.empty());
        if (optionalTeleporter.isEmpty()) {
            if (args.length == 0) {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                return;
            }
            this.plugin.getLocales().getLocale("error_player_not_found", args[0]).ifPresent(executor::sendMessage);
            return;
        }
        OnlineUser teleporter = (OnlineUser)optionalTeleporter.get();
        this.validateRtp(teleporter, executor, args.length > 1 ? this.removeFirstArg(args) : args).ifPresent(world -> this.executeRtp(teleporter, executor, (World)world, args));
    }

    @Override
    @Nullable
    public List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> {
                if (user.hasPermission("other")) {
                    yield UserListTabProvider.super.suggestLocal(args);
                }
                if (user instanceof OnlineUser) {
                    OnlineUser online = (OnlineUser)user;
                    yield List.of(online.getUsername());
                }
                yield List.of();
            }
            case 2 -> {
                if (user.hasPermission("world")) {
                    yield this.plugin.getWorlds().stream().filter(w -> !this.plugin.getSettings().isWorldRtpRestricted((World)w)).map(World::getName).toList();
                }
                yield List.of();
            }
            default -> null;
        };
    }

    private Optional<World> validateRtp(@NotNull OnlineUser teleporter, @NotNull CommandUser executor, @NotNull String[] args) {
        Optional<World> optionalWorld;
        if (!executor.equals(teleporter) && !executor.hasPermission(this.getPermission("other"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (!this.plugin.validateTransaction(teleporter, TransactionResolver.Action.RANDOM_TELEPORT)) {
            return Optional.empty();
        }
        World teleporterWorld = teleporter.getPosition().getWorld();
        Optional<World> optional = optionalWorld = args.length >= 1 ? this.plugin.getWorlds().stream().filter(w -> w.getName().equalsIgnoreCase(args[0])).findFirst() : Optional.of(teleporterWorld);
        if (optionalWorld.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_world", args[0]).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        World world = optionalWorld.get();
        if (!world.equals(teleporterWorld) && !executor.hasPermission(this.getPermission("world"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (this.plugin.getSettings().isWorldRtpRestricted(world)) {
            this.plugin.getLocales().getLocale("error_rtp_restricted_world").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        return Optional.of(world);
    }

    private void executeRtp(@NotNull OnlineUser teleporter, @NotNull CommandUser executor, @NotNull World world, @NotNull String[] args) {
        this.plugin.getLocales().getLocale("teleporting_random_generation").ifPresent(teleporter::sendMessage);
        this.plugin.getRandomTeleportEngine().getRandomPosition(world, args.length > 1 ? this.removeFirstArg(args) : args).thenAccept(position -> {
            if (position.isEmpty()) {
                this.plugin.getLocales().getLocale("error_rtp_randomization_timeout").ifPresent(executor::sendMessage);
                return;
            }
            TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleporter).actions(TransactionResolver.Action.RANDOM_TELEPORT).target((Target)position.get());
            try {
                if (executor.equals(teleporter)) {
                    builder.toTimedTeleport().execute();
                } else {
                    builder.toTeleport().execute();
                }
            }
            catch (TeleportationException e) {
                e.displayMessage(executor, args);
            }
        });
    }
}

