/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.ListCommand;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paginedown.PaginatedList;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;

public class PublicHomeListCommand
extends ListCommand {
    protected PublicHomeListCommand(@NotNull HuskHomes plugin) {
        super("phomelist", List.of("phomes", "publichomelist"), "[page]", plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        int pageNumber = this.parseIntArg(args, 0).orElse(1);
        this.showPublicHomeList(executor, pageNumber);
    }

    protected void showPublicHomeList(@NotNull CommandUser executor, int pageNumber) {
        OnlineUser user;
        if (executor instanceof OnlineUser && this.cachedLists.containsKey((user = (OnlineUser)executor).getUuid())) {
            executor.sendMessage(((PaginatedList)this.cachedLists.get(user.getUuid())).getNearestValidPage(pageNumber));
            return;
        }
        List<Home> homes = this.plugin.getDatabase().getPublicHomes();
        this.plugin.fireEvent(this.plugin.getViewHomeListEvent(homes, executor, true), event -> this.generateList(executor, event.getHomes()).ifPresent(homeList -> {
            if (executor instanceof OnlineUser) {
                OnlineUser onlineUser = (OnlineUser)executor;
                this.cachedLists.put(onlineUser.getUuid(), homeList);
            }
            executor.sendMessage(homeList.getNearestValidPage(pageNumber));
        }));
    }

    private Optional<PaginatedList> generateList(@NotNull CommandUser executor, @NotNull List<Home> publicHomes) {
        if (publicHomes.isEmpty()) {
            this.plugin.getLocales().getLocale("error_no_public_homes_set").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        PaginatedList homeList = PaginatedList.of(publicHomes.stream().map(home -> this.plugin.getLocales().getRawLocale("public_home_list_item", Locales.escapeText(home.getName()), home.getSafeIdentifier(), Locales.escapeText(home.getOwner().getUsername()), Locales.escapeText(this.plugin.getLocales().wrapText(home.getMeta().getDescription(), 40))).orElse(home.getName())).sorted().collect(Collectors.toList()), this.plugin.getLocales().getBaseList(this.plugin.getSettings().getListItemsPerPage()).setHeaderFormat(this.plugin.getLocales().getRawLocale("public_home_list_page_title", "%first_item_on_page_index%", "%last_item_on_page_index%", "%total_items%").orElse("")).setCommand("/huskhomes:phomelist").build());
        return Optional.of(homeList);
    }
}

