/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.TabProvider;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.adventure.text.Component;
import net.william278.huskhomes.libraries.adventure.text.format.TextColor;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.desertwell.about.AboutMenu;
import net.william278.huskhomes.libraries.desertwell.util.UpdateChecker;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.libraries.paginedown.PaginatedList;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public class HuskHomesCommand
extends Command
implements TabProvider {
    private static final Map<String, Boolean> SUB_COMMANDS = Map.of("about", false, "help", false, "reload", true, "import", true, "delete", true, "update", true);
    private boolean importersLoaded = false;
    private final UpdateChecker updateChecker;
    private final AboutMenu aboutMenu;

    protected HuskHomesCommand(@NotNull HuskHomes plugin) {
        super("huskhomes", List.of(), "[" + String.join((CharSequence)"|", SUB_COMMANDS.keySet()) + "]", plugin);
        this.addAdditionalPermissions(SUB_COMMANDS);
        this.updateChecker = plugin.getUpdateChecker();
        this.aboutMenu = AboutMenu.builder().title(Component.text("HuskHomes")).description(Component.text("The powerful and intuitive homes, warps, and teleports plugin/mod")).version(plugin.getVersion()).credits("Author", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net")).credits("Contributors", AboutMenu.Credit.of("imDaniX").description("Code, refactoring"), AboutMenu.Credit.of("Log1x").description("Code")).credits("Translators", AboutMenu.Credit.of("SnivyJ").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("ApliNi").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("Wtq_").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("TonyPak").description("Traditional Chinese (zh-tw)"), AboutMenu.Credit.of("davgo0103").description("Traditional Chinese (zh-tw)"), AboutMenu.Credit.of("Villag3r_").description("Italian (it-it)"), AboutMenu.Credit.of("ReferTV").description("Polish (pl)"), AboutMenu.Credit.of("anchelthe").description("Spanish (es-es)"), AboutMenu.Credit.of("Chiquis2005").description("Spanish (es-es)"), AboutMenu.Credit.of("Ceddix").description("German, (de-de)"), AboutMenu.Credit.of("Pukejoy_1").description("Bulgarian (bg-bg)")).buttons(AboutMenu.Link.of("https://william278.net/docs/huskhomes").text("Documentation").icon("\u26cf"), AboutMenu.Link.of("https://github.com/WiIIiam278/HuskHomes/issues").text("Issues").icon("\u274c").color(TextColor.color(0xFF9F0F)), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color(6779893))).build();
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        String action = this.parseStringArg(args, 0).orElse("about");
        if (SUB_COMMANDS.containsKey(action) && !executor.hasPermission(this.getPermission(action))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        block8 : switch (action.toLowerCase()) {
            case "about": {
                executor.sendMessage(this.aboutMenu.toComponent());
                break;
            }
            case "help": {
                executor.sendMessage(this.getCommandList(executor).getNearestValidPage(this.parseIntArg(args, 1).orElse(1)));
                break;
            }
            case "reload": {
                if (!this.plugin.loadConfigs()) {
                    executor.sendMessage(new MineDown("[Error:](#ff3300) [Failed to reload the plugin. Check console for errors.](#ff7e5e)"));
                    return;
                }
                executor.sendMessage(new MineDown("[HuskHomes](#00fb9a bold) [| Reloaded config & message files.](#00fb9a)\n[\u2139 If you have modified the database or cross-server message broker settings, you need to restart your server for these changes to take effect.](gray)"));
                break;
            }
            case "import": {
                if (!this.importersLoaded) {
                    this.importersLoaded = true;
                    this.plugin.registerImporters();
                }
                if (this.plugin.getImporters().isEmpty()) {
                    this.plugin.getLocales().getLocale("error_no_importers_available").ifPresent(executor::sendMessage);
                    return;
                }
                this.importData(executor, this.removeFirstArg(args));
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                    return;
                }
                String[] deletionArgs = this.removeFirstArg(args);
                switch (deletionArgs[0].toLowerCase(Locale.ENGLISH)) {
                    case "player": {
                        this.deletePlayerData(executor, this.removeFirstArg(deletionArgs));
                        break block8;
                    }
                    case "homes": {
                        this.deleteHomes(executor, this.removeFirstArg(deletionArgs));
                        break block8;
                    }
                    case "warps": {
                        this.deleteWarps(executor, this.removeFirstArg(deletionArgs));
                        break block8;
                    }
                }
                this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete <player|homes|warps> [args]").ifPresent(executor::sendMessage);
                break;
            }
            case "update": {
                this.updateChecker.check().thenAccept(checked -> {
                    if (checked.isUpToDate()) {
                        this.plugin.getLocales().getLocale("up_to_date", this.plugin.getVersion().toString()).ifPresent(executor::sendMessage);
                        return;
                    }
                    this.plugin.getLocales().getLocale("update_available", checked.getLatestVersion().toString(), this.plugin.getVersion().toString()).ifPresent(executor::sendMessage);
                });
                break;
            }
            default: {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            }
        }
    }

    private void importData(@NotNull CommandUser executor, @NotNull String[] args) {
        switch (this.parseStringArg(args, 0).orElse("list")) {
            case "start": {
                this.parseStringArg(args, 1).ifPresentOrElse(name -> {
                    Optional<Importer> importer = this.plugin.getImporters().stream().filter(available -> available.getImporterName().equalsIgnoreCase((String)name)).findFirst();
                    if (importer.isEmpty()) {
                        this.plugin.getLocales().getLocale("error_invalid_importer").ifPresent(executor::sendMessage);
                        return;
                    }
                    importer.get().start(executor);
                }, () -> this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " import start <importer>").ifPresent(executor::sendMessage));
                break;
            }
            case "list": {
                executor.sendMessage(this.getImporterList().getNearestValidPage(this.parseIntArg(args, 1).orElse(1)));
                break;
            }
            default: {
                this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " import <start|list>").ifPresent(executor::sendMessage);
            }
        }
    }

    private void deletePlayerData(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional<String> nameOrUuid = this.parseStringArg(args, 0);
        if (nameOrUuid.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete player <player> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            Optional<SavedUser> savedUser;
            try {
                savedUser = this.plugin.getDatabase().getUserData(UUID.fromString((String)nameOrUuid.get()));
            }
            catch (IllegalArgumentException e) {
                savedUser = this.plugin.getDatabase().getUserDataByName((String)nameOrUuid.get());
            }
            if (savedUser.isEmpty()) {
                this.plugin.getLocales().getLocale("error_player_not_found", (String)nameOrUuid.get()).ifPresent(executor::sendMessage);
                return;
            }
            User user = savedUser.get().getUser();
            if (!this.parseStringArg(args, 1).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
                this.plugin.getLocales().getLocale("delete_player_confirm", savedUser.get().getUser().getUsername()).ifPresent(executor::sendMessage);
                return;
            }
            int homesDeleted = this.plugin.getManager().homes().deleteAllHomes(user);
            this.plugin.getDatabase().deleteUserData(user.getUuid());
            this.plugin.getLocales().getLocale("delete_player_success", savedUser.get().getUser().getUsername(), Integer.toString(homesDeleted)).ifPresent(executor::sendMessage);
        });
    }

    private void deleteHomes(@NotNull CommandUser executor, @NotNull String[] args) {
        Map<String, String> filters;
        try {
            filters = this.getBulkDeleteFilters(args);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete homes <world> <server> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        if (!this.parseStringArg(args, 2).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
            this.plugin.getLocales().getLocale("bulk_delete_homes_confirm", filters.get("world"), filters.get("server")).ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            int homesDeleted = this.plugin.getManager().homes().deleteAllHomes((String)filters.get("world"), (String)filters.get("server"));
            this.plugin.getLocales().getLocale("bulk_delete_homes_success", Integer.toString(homesDeleted), (String)filters.get("world"), (String)filters.get("server")).ifPresent(executor::sendMessage);
        });
    }

    private void deleteWarps(@NotNull CommandUser executor, @NotNull String[] args) {
        Map<String, String> filters;
        try {
            filters = this.getBulkDeleteFilters(args);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/" + this.getName() + " delete warps <world> <server> [confirm]").ifPresent(executor::sendMessage);
            return;
        }
        if (!this.parseStringArg(args, 2).map(a -> a.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
            this.plugin.getLocales().getLocale("bulk_delete_warps_confirm", filters.get("world"), filters.get("server")).ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> {
            int homesDeleted = this.plugin.getManager().warps().deleteAllWarps((String)filters.get("world"), (String)filters.get("server"));
            this.plugin.getLocales().getLocale("bulk_delete_warps_success", Integer.toString(homesDeleted), (String)filters.get("world"), (String)filters.get("server")).ifPresent(executor::sendMessage);
        });
    }

    @NotNull
    private Map<String, String> getBulkDeleteFilters(@NotNull String[] args) throws IllegalArgumentException {
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put("world", this.parseStringArg(args, 0).orElseThrow(() -> new IllegalArgumentException("World not specified")));
        filters.put("server", this.parseStringArg(args, 1).orElse(this.plugin.getServerName()));
        return filters;
    }

    @NotNull
    private PaginatedList getCommandList(@NotNull CommandUser user) {
        return PaginatedList.of(this.plugin.getCommands().stream().filter(command -> user.hasPermission(command.getPermission(new String[0]))).map(command -> this.plugin.getLocales().getRawLocale("command_list_item", Locales.escapeText(command.getName()), Locales.escapeText(this.plugin.getLocales().truncateText(command.getDescription(), 50)), Locales.escapeText(String.format("%s\n\n%s", this.plugin.getLocales().wrapText(command.getUsage(), 50), this.plugin.getLocales().wrapText(command.getDescription(), 50)))).orElse(command.getName())).collect(Collectors.toList()), this.plugin.getLocales().getBaseList(Math.min(this.plugin.getSettings().getListItemsPerPage(), 6)).setHeaderFormat(this.plugin.getLocales().getRawLocale("command_list_title").orElse("")).setItemSeparator("\n").setCommand("/huskhomes:huskhomes help").build());
    }

    @NotNull
    private PaginatedList getImporterList() {
        return PaginatedList.of(this.plugin.getImporters().stream().map(importer -> this.plugin.getLocales().getRawLocale("importer_list_item", Locales.escapeText(importer.getImporterName()), Locales.escapeText(importer.getSupportedImportData().stream().map(Importer.ImportData::getName).collect(Collectors.joining(", ")))).orElse(importer.getName())).collect(Collectors.toList()), this.plugin.getLocales().getBaseList(Math.min(this.plugin.getSettings().getListItemsPerPage(), 6)).setHeaderFormat(this.plugin.getLocales().getRawLocale("importer_list_title").orElse("")).setItemSeparator("\n").setCommand("/huskhomes:huskhomes import list").build());
    }

    @Override
    @Nullable
    public List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> SUB_COMMANDS.keySet().stream().sorted().toList();
            case 2 -> {
                switch (args[0].toLowerCase()) {
                    case "help": {
                        yield IntStream.rangeClosed(1, this.getCommandList(user).getTotalPages()).mapToObj(Integer::toString).toList();
                    }
                    case "import": {
                        yield List.of("start", "list");
                    }
                    case "delete": {
                        yield List.of("player", "homes", "warps");
                    }
                }
                yield null;
            }
            case 3 -> {
                if (!args[0].equalsIgnoreCase("import") && !args[1].equalsIgnoreCase("start")) {
                    yield null;
                }
                yield this.plugin.getImporters().stream().map(Importer::getImporterName).toList();
            }
            default -> null;
        };
    }
}

