/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class EditWarpCommand
extends SavedPositionCommand<Warp> {
    public EditWarpCommand(@NotNull HuskHomes plugin) {
        super("editwarp", List.of(), Warp.class, List.of("rename", "description", "relocate"), plugin);
        this.setOperatorCommand(true);
        this.addAdditionalPermissions(this.arguments.stream().collect(HashMap::new, (m, e) -> m.put(e, false), HashMap::putAll));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull Warp warp, @NotNull String[] args) {
        Optional<String> operation = this.parseStringArg(args, 0);
        if (operation.isEmpty()) {
            this.getWarpEditorWindow(warp).forEach(executor::sendMessage);
            return;
        }
        if (!this.arguments.contains(operation.get().toLowerCase())) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        switch (operation.get().toLowerCase()) {
            case "rename": {
                this.setWarpName(executor, warp, args);
                break;
            }
            case "description": {
                this.setWarpDescription(executor, warp, args);
                break;
            }
            case "relocate": {
                this.setWarpPosition(executor, warp);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + operation.get().toLowerCase());
            }
        }
    }

    private void setWarpName(@NotNull CommandUser executor, @NotNull Warp warp, @NotNull String[] args) {
        String oldName = warp.getName();
        Optional<String> optionalName = this.parseStringArg(args, 1);
        if (optionalName.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/editwarp " + warp.getName() + " rename <name>").ifPresent(executor::sendMessage);
            return;
        }
        warp.getMeta().setName(optionalName.get());
        this.plugin.fireEvent(this.plugin.getWarpEditEvent(warp, executor), event -> {
            try {
                this.plugin.getManager().warps().setWarpName(warp, warp.getName());
            }
            catch (ValidationException e) {
                e.dispatchWarpError(executor, this.plugin, warp.getName());
                return;
            }
            this.plugin.getLocales().getLocale("edit_warp_update_name", oldName, (String)optionalName.get()).ifPresent(executor::sendMessage);
        });
    }

    private void setWarpDescription(@NotNull CommandUser executor, @NotNull Warp warp, @NotNull String[] args) {
        Optional<String> optionalDescription = this.parseGreedyArguments(args);
        if (optionalDescription.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", "/editwarp " + warp.getName() + " description <text>").ifPresent(executor::sendMessage);
            return;
        }
        warp.getMeta().setDescription(optionalDescription.get());
        this.plugin.fireEvent(this.plugin.getWarpEditEvent(warp, executor), event -> {
            try {
                this.plugin.getManager().warps().setWarpDescription(warp, warp.getMeta().getDescription());
            }
            catch (ValidationException e) {
                e.dispatchWarpError(executor, this.plugin, warp.getMeta().getDescription());
                return;
            }
            this.plugin.getLocales().getLocale("edit_warp_update_description", warp.getName(), warp.getMeta().getDescription()).ifPresent(executor::sendMessage);
        });
    }

    private void setWarpPosition(@NotNull CommandUser executor, @NotNull Warp warp) {
        if (!(executor instanceof OnlineUser)) {
            this.plugin.getLocales().getLocale("error_in_game_only").ifPresent(executor::sendMessage);
            return;
        }
        OnlineUser user = (OnlineUser)executor;
        warp.update(user.getPosition());
        this.plugin.fireEvent(this.plugin.getWarpEditEvent(warp, executor), event -> {
            try {
                this.plugin.getManager().warps().setWarpPosition(warp, (Position)warp);
            }
            catch (ValidationException e) {
                e.dispatchWarpError(executor, this.plugin, warp.getName());
                return;
            }
            this.plugin.getLocales().getLocale("edit_warp_update_location", warp.getName()).ifPresent(executor::sendMessage);
        });
    }

    @NotNull
    private List<MineDown> getWarpEditorWindow(@NotNull Warp warp) {
        ArrayList<MineDown> messages = new ArrayList<MineDown>();
        this.plugin.getLocales().getLocale("edit_warp_menu_title", warp.getName()).ifPresent(messages::add);
        this.plugin.getLocales().getLocale("edit_warp_menu_metadata", DateTimeFormatter.ofPattern("MMM dd yyyy, HH:mm").format(warp.getMeta().getCreationTime().atZone(ZoneId.systemDefault())), warp.getUuid().toString().split(Pattern.quote("-"))[0], warp.getUuid().toString()).ifPresent(messages::add);
        if (warp.getMeta().getDescription().length() > 0) {
            this.plugin.getLocales().getLocale("edit_warp_menu_description", this.plugin.getLocales().truncateText(warp.getMeta().getDescription(), 50), this.plugin.getLocales().wrapText(warp.getMeta().getDescription(), 40)).ifPresent(messages::add);
        }
        if (!this.plugin.getSettings().doCrossServer()) {
            this.plugin.getLocales().getLocale("edit_warp_menu_world", warp.getWorld().getName()).ifPresent(messages::add);
        } else {
            this.plugin.getLocales().getLocale("edit_warp_menu_world_server", warp.getWorld().getName(), warp.getServer()).ifPresent(messages::add);
        }
        this.plugin.getLocales().getLocale("edit_warp_menu_coordinates", String.format("%.1f", warp.getX()), String.format("%.1f", warp.getY()), String.format("%.1f", warp.getZ()), String.format("%.2f", Float.valueOf(warp.getYaw())), String.format("%.2f", Float.valueOf(warp.getPitch()))).ifPresent(messages::add);
        this.plugin.getLocales().getLocale("edit_warp_menu_use_buttons", warp.getSafeIdentifier()).ifPresent(messages::add);
        this.plugin.getLocales().getLocale("edit_warp_menu_manage_buttons", warp.getSafeIdentifier()).ifPresent(messages::add);
        this.plugin.getLocales().getLocale("edit_warp_menu_meta_edit_buttons", warp.getSafeIdentifier()).ifPresent(messages::add);
        return messages;
    }
}

