/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.SavedPositionCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;

public class DelHomeCommand
extends SavedPositionCommand<Home> {
    public DelHomeCommand(@NotNull HuskHomes plugin) {
        super("delhome", List.of(), Home.class, List.of(), plugin);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        OnlineUser user;
        if (executor instanceof OnlineUser && this.handleDeleteAll(user = (OnlineUser)executor, args)) {
            return;
        }
        super.execute(executor, args);
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull Home home, @NotNull String[] args) {
        if (executor instanceof OnlineUser) {
            OnlineUser user = (OnlineUser)executor;
            if (!home.getOwner().equals(user) && !user.hasPermission(this.getOtherPermission())) {
                this.plugin.getLocales().getLocale("error_no_permission").ifPresent(user::sendMessage);
                return;
            }
        }
        this.plugin.fireEvent(this.plugin.getHomeDeleteEvent(home, executor), event -> {
            try {
                this.plugin.getManager().homes().deleteHome(home);
            }
            catch (ValidationException e) {
                e.dispatchHomeError(executor, !home.getOwner().equals(executor), this.plugin, home.getName());
                return;
            }
            this.plugin.getLocales().getLocale("home_deleted", home.getName()).ifPresent(executor::sendMessage);
        });
    }

    private boolean handleDeleteAll(@NotNull OnlineUser user, @NotNull String[] args) {
        if (args.length >= 1 && args[0].equalsIgnoreCase("all")) {
            if (!this.parseStringArg(args, 1).map(confirm -> confirm.equalsIgnoreCase("confirm")).orElse(false).booleanValue()) {
                this.plugin.getLocales().getLocale("delete_all_homes_confirm").ifPresent(user::sendMessage);
                return true;
            }
            this.plugin.fireEvent(this.plugin.getDeleteAllHomesEvent(user, user), event -> {
                int deleted = this.plugin.getManager().homes().deleteAllHomes(user);
                if (deleted == 0) {
                    this.plugin.getLocales().getLocale("error_no_homes_set").ifPresent(user::sendMessage);
                    return;
                }
                this.plugin.getLocales().getLocale("delete_all_homes_success", Integer.toString(deleted)).ifPresent(user::sendMessage);
            });
            return true;
        }
        return false;
    }
}

