/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Node;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.user.CommandUser;

public abstract class Command
extends Node {
    private final String usage;
    private final Map<String, Boolean> additionalPermissions;

    protected Command(@NotNull String name, @NotNull List<String> aliases, @NotNull String usage, @NotNull HuskHomes plugin) {
        super(name, aliases, plugin);
        this.usage = usage;
        this.additionalPermissions = new HashMap<String, Boolean>();
    }

    @Override
    public final void onExecuted(@NotNull CommandUser executor, @NotNull String[] args) {
        if (!executor.hasPermission(this.getPermission(new String[0]))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return;
        }
        this.plugin.runAsync(() -> this.execute(executor, args));
    }

    public abstract void execute(@NotNull CommandUser var1, @NotNull String[] var2);

    @NotNull
    protected String[] removeFirstArg(@NotNull String[] args) {
        if (args.length <= 1) {
            return new String[0];
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        return newArgs;
    }

    @NotNull
    public final String getRawUsage() {
        return this.usage;
    }

    @NotNull
    public final String getUsage() {
        return String.format("/%s %s", this.getName(), this.getRawUsage());
    }

    public final void addAdditionalPermissions(@NotNull Map<String, Boolean> permissions) {
        permissions.forEach((permission, value) -> this.additionalPermissions.put(this.getPermission((String)permission), (Boolean)value));
    }

    @NotNull
    public final Map<String, Boolean> getAdditionalPermissions() {
        return this.additionalPermissions;
    }

    @NotNull
    public String getDescription() {
        return this.plugin.getLocales().getRawLocale(this.getName() + "_command_description").orElse(this.getUsage());
    }

    @NotNull
    public final HuskHomes getPlugin() {
        return this.plugin;
    }
}

