/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.BackCommand;
import net.william278.huskhomes.command.BrigadierUtil;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.DelHomeCommand;
import net.william278.huskhomes.command.DelWarpCommand;
import net.william278.huskhomes.command.EditHomeCommand;
import net.william278.huskhomes.command.EditWarpCommand;
import net.william278.huskhomes.command.HuskHomesCommand;
import net.william278.huskhomes.command.PrivateHomeCommand;
import net.william278.huskhomes.command.PrivateHomeListCommand;
import net.william278.huskhomes.command.PublicHomeCommand;
import net.william278.huskhomes.command.PublicHomeListCommand;
import net.william278.huskhomes.command.RtpCommand;
import net.william278.huskhomes.command.SetHomeCommand;
import net.william278.huskhomes.command.SetSpawnCommand;
import net.william278.huskhomes.command.SetWarpCommand;
import net.william278.huskhomes.command.SpawnCommand;
import net.william278.huskhomes.command.TabProvider;
import net.william278.huskhomes.command.TeleportRequestCommand;
import net.william278.huskhomes.command.TpAllCommand;
import net.william278.huskhomes.command.TpCommand;
import net.william278.huskhomes.command.TpHereCommand;
import net.william278.huskhomes.command.TpIgnoreCommand;
import net.william278.huskhomes.command.TpOfflineCommand;
import net.william278.huskhomes.command.TpRespondCommand;
import net.william278.huskhomes.command.TpaAllCommand;
import net.william278.huskhomes.command.WarpCommand;
import net.william278.huskhomes.command.WarpListCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.commodore.CommodoreProvider;
import net.william278.huskhomes.teleport.TeleportRequest;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.ConsoleUser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public class BukkitCommand
extends org.bukkit.command.Command {
    private final BukkitHuskHomes plugin;
    private final Command command;

    public BukkitCommand(@NotNull Command command, @NotNull BukkitHuskHomes plugin) {
        super(command.getName(), command.getDescription(), command.getUsage(), command.getAliases());
        this.command = command;
        this.plugin = plugin;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        CommandUser commandUser;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            commandUser = BukkitUser.adapt(p, this.plugin);
        } else {
            commandUser = this.plugin.getConsole();
        }
        this.command.onExecuted(commandUser, args);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        CommandUser commandUser;
        Command command = this.command;
        if (!(command instanceof TabProvider)) {
            return List.of();
        }
        TabProvider provider = (TabProvider)((Object)command);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            commandUser = BukkitUser.adapt(p, this.plugin);
        } else {
            commandUser = this.plugin.getConsole();
        }
        ConsoleUser user = commandUser;
        return provider.getSuggestions(user, args);
    }

    public void register() {
        this.plugin.getCommandRegistrar().getServerCommandMap().register("huskhomes", (org.bukkit.command.Command)this);
        BukkitCommand.addPermission(this.plugin, this.command.getPermission(new String[0]), this.command.getUsage(), BukkitCommand.getPermissionDefault(this.command.isOperatorCommand()), new Permission[0]);
        List<Permission> childNodes = this.command.getAdditionalPermissions().entrySet().stream().map(entry -> BukkitCommand.addPermission(this.plugin, (String)entry.getKey(), "", BukkitCommand.getPermissionDefault((Boolean)entry.getValue()), new Permission[0])).filter(Objects::nonNull).toList();
        if (!childNodes.isEmpty()) {
            BukkitCommand.addPermission(this.plugin, this.command.getPermission("*"), this.command.getUsage(), PermissionDefault.FALSE, childNodes.toArray(new Permission[0]));
        }
        if (CommodoreProvider.isSupported() && this.plugin.getSettings().doBrigadierTabCompletion()) {
            BrigadierUtil.registerCommodore(this.plugin, this, this.command);
        }
    }

    @Nullable
    protected static Permission addPermission(@NotNull BukkitHuskHomes plugin, @NotNull String node, @NotNull String description, @NotNull PermissionDefault permissionDefault, Permission ... children) {
        Map childNodes = Arrays.stream(children).map(Permission::getName).collect(HashMap::new, (map, child) -> map.put(child, true), HashMap::putAll);
        PluginManager manager = plugin.getServer().getPluginManager();
        if (manager.getPermission(node) != null) {
            return null;
        }
        Permission permission = description.isEmpty() ? new Permission(node, permissionDefault, childNodes) : new Permission(node, description, permissionDefault, childNodes);
        manager.addPermission(permission);
        return permission;
    }

    @NotNull
    protected static PermissionDefault getPermissionDefault(boolean isOperatorCommand) {
        return isOperatorCommand ? PermissionDefault.OP : PermissionDefault.TRUE;
    }

    public static enum Type {
        HOME_COMMAND(PrivateHomeCommand::new),
        SET_HOME_COMMAND(SetHomeCommand::new),
        HOME_LIST_COMMAND(PrivateHomeListCommand::new),
        DEL_HOME_COMMAND(DelHomeCommand::new),
        EDIT_HOME_COMMAND(EditHomeCommand::new),
        PUBLIC_HOME_COMMAND(PublicHomeCommand::new),
        PUBLIC_HOME_LIST_COMMAND(PublicHomeListCommand::new),
        WARP_COMMAND(WarpCommand::new),
        SET_WARP_COMMAND(SetWarpCommand::new),
        WARP_LIST_COMMAND(WarpListCommand::new),
        DEL_WARP_COMMAND(DelWarpCommand::new),
        EDIT_WARP_COMMAND(EditWarpCommand::new),
        TP_COMMAND(TpCommand::new),
        TP_HERE_COMMAND(TpHereCommand::new),
        TPA_COMMAND(plugin -> new TeleportRequestCommand((HuskHomes)plugin, TeleportRequest.Type.TPA)),
        TPA_HERE_COMMAND(plugin -> new TeleportRequestCommand((HuskHomes)plugin, TeleportRequest.Type.TPA_HERE)),
        TPACCEPT_COMMAND(plugin -> new TpRespondCommand((HuskHomes)plugin, true)),
        TPDECLINE_COMMAND(plugin -> new TpRespondCommand((HuskHomes)plugin, false)),
        RTP_COMMAND(RtpCommand::new),
        TP_IGNORE_COMMAND(TpIgnoreCommand::new),
        TP_OFFLINE_COMMAND(TpOfflineCommand::new),
        TP_ALL_COMMAND(TpAllCommand::new),
        TPA_ALL_COMMAND(TpaAllCommand::new),
        SPAWN_COMMAND(SpawnCommand::new),
        SET_SPAWN_COMMAND(SetSpawnCommand::new),
        BACK_COMMAND(BackCommand::new),
        HUSKHOMES_COMMAND(HuskHomesCommand::new);

        private final Function<HuskHomes, Command> supplier;

        private Type(Function<HuskHomes, Command> supplier) {
            this.supplier = supplier;
        }

        @NotNull
        public Command createCommand(@NotNull HuskHomes plugin) {
            return this.supplier.apply(plugin);
        }

        @NotNull
        public static List<Command> getCommands(@NotNull BukkitHuskHomes plugin) {
            return Arrays.stream(Type.values()).map(type -> type.createCommand(plugin)).filter(command -> !plugin.getSettings().isCommandDisabled((Command)command)).peek(command -> new BukkitCommand((Command)command, plugin).register()).toList();
        }
    }
}

