/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.api;

import java.util.Objects;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.api.BaseHuskHomesAPI;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.BukkitAdapter;
import org.bukkit.entity.Player;

public class HuskHomesAPI
extends BaseHuskHomesAPI {
    private static HuskHomesAPI instance;

    @ApiStatus.Internal
    private HuskHomesAPI(@NotNull BukkitHuskHomes plugin) {
        super(plugin);
    }

    @NotNull
    public static HuskHomesAPI getInstance() throws BaseHuskHomesAPI.NotRegisteredException {
        if (instance == null) {
            throw new BaseHuskHomesAPI.NotRegisteredException();
        }
        return instance;
    }

    @ApiStatus.Internal
    public static void register(@NotNull BukkitHuskHomes plugin) {
        instance = new HuskHomesAPI(plugin);
    }

    @ApiStatus.Internal
    public static void unregister() {
        instance = null;
    }

    @NotNull
    public OnlineUser adaptUser(@NotNull Player player) {
        return BukkitUser.adapt(player, (BukkitHuskHomes)this.plugin);
    }

    @NotNull
    public Player getPlayer(@NotNull OnlineUser user) {
        return ((BukkitUser)user).getPlayer();
    }

    @Nullable
    public org.bukkit.Location getLocation(@NotNull Position position) {
        return BukkitAdapter.adaptLocation(position).orElse(null);
    }

    @Nullable
    public Location adaptLocation(@NotNull org.bukkit.Location location) {
        return BukkitAdapter.adaptLocation(location).orElse(null);
    }

    @NotNull
    public Position adaptPosition(@NotNull org.bukkit.Location location, @NotNull String server) {
        return Position.at(Objects.requireNonNull(this.adaptLocation(location)), server);
    }

    @NotNull
    public Position adaptPosition(@NotNull org.bukkit.Location location) {
        return Position.at(Objects.requireNonNull(this.adaptLocation(location)), this.getServer());
    }

    @NotNull
    public String getServer() {
        return this.plugin.getServerName();
    }
}

