/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.api;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.ApiStatus;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.random.RandomTeleportEngine;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.TransactionResolver;

public abstract class BaseHuskHomesAPI {
    protected final HuskHomes plugin;

    @ApiStatus.Internal
    protected BaseHuskHomesAPI(@NotNull HuskHomes plugin) {
        this.plugin = plugin;
    }

    public final CompletableFuture<Optional<SavedUser>> getUserData(@NotNull UUID uuid) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getUserData(uuid));
    }

    public final CompletableFuture<Optional<SavedUser>> getUserData(@NotNull String username) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getUserDataByName(username));
    }

    public final CompletableFuture<Optional<Instant>> getCooldown(@NotNull User user, @NotNull TransactionResolver.Action action) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getCooldown(action, user));
    }

    public final void setCooldown(@NotNull User user, @NotNull TransactionResolver.Action action, @NotNull Instant expiry) throws IllegalArgumentException {
        if (Instant.now().isAfter(expiry)) {
            throw new IllegalArgumentException("Cooldown expiry time must be in the future");
        }
        this.plugin.runAsync(() -> this.plugin.getDatabase().setCooldown(action, user, expiry));
    }

    public final void setCooldown(@NotNull User user, @NotNull TransactionResolver.Action action, @NotNull Duration duration) throws IllegalArgumentException {
        this.setCooldown(user, action, Instant.now().plus(duration));
    }

    public final void removeCooldown(@NotNull User user, @NotNull TransactionResolver.Action action) {
        this.plugin.runAsync(() -> this.plugin.getDatabase().removeCooldown(action, user));
    }

    public CompletableFuture<Optional<Position>> getUserLastPosition(@NotNull User user) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getLastPosition(user));
    }

    public void setUserLastPosition(@NotNull User user, @NotNull Position position) {
        this.plugin.runAsync(() -> this.plugin.getDatabase().setLastPosition(user, position));
    }

    public CompletableFuture<Optional<Position>> getUserOfflinePosition(@NotNull User user) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getOfflinePosition(user));
    }

    public CompletableFuture<Optional<Position>> getUserRespawnPosition(@NotNull User user) {
        if (!this.plugin.getSettings().doCrossServer() || this.plugin.getSettings().isGlobalRespawning()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getRespawnPosition(user));
    }

    public boolean isUserWarmingUp(@NotNull User user) {
        return this.plugin.isWarmingUp(user.getUuid());
    }

    public final void saveUserData(@NotNull SavedUser savedUser) {
        this.plugin.runAsync(() -> this.plugin.getDatabase().updateUserData(savedUser));
    }

    public final void editUserData(@NotNull String username, @NotNull Consumer<SavedUser> editor) {
        this.plugin.getSavedUsers().stream().findAny().ifPresent(savedUser -> {
            if (savedUser.getUsername().equalsIgnoreCase(username)) {
                editor.accept((SavedUser)savedUser);
                this.saveUserData((SavedUser)savedUser);
            }
        });
    }

    public final void editUserData(@NotNull UUID uuid, @NotNull Consumer<SavedUser> editor) {
        this.plugin.getSavedUsers().stream().findAny().ifPresent(savedUser -> {
            if (savedUser.getUser().getUuid().equals(uuid)) {
                editor.accept((SavedUser)savedUser);
                this.saveUserData((SavedUser)savedUser);
            }
        });
    }

    public final CompletableFuture<List<Home>> getUserHomes(@NotNull User user) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getHomes(user));
    }

    public final CompletableFuture<List<Home>> getUserPublicHomes(@NotNull User user) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getHomes(user).stream().filter(Home::isPublic).collect(Collectors.toList()));
    }

    public final CompletableFuture<List<Home>> getLocalPublicHomes(@NotNull User user) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getLocalPublicHomes(this.plugin));
    }

    public final CompletableFuture<List<Home>> getPublicHomes() {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getPublicHomes());
    }

    public final CompletableFuture<Optional<Home>> getHome(@NotNull User user, @NotNull String homeName) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getHome(user, homeName));
    }

    public final CompletableFuture<Optional<Home>> getHome(@NotNull UUID homeUuid) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getHome(homeUuid));
    }

    public CompletableFuture<Home> createHome(@NotNull User owner, @NotNull String name, @NotNull Position position) {
        return this.createHome(owner, name, position, false, false, false);
    }

    public CompletableFuture<Home> createHome(@NotNull User owner, @NotNull String name, @NotNull Position position, boolean overwrite, boolean buyAdditionalSlots, boolean ignoreMaxHomes) {
        return this.plugin.supplyAsync(() -> this.plugin.getManager().homes().createHome(owner, name, position, overwrite, buyAdditionalSlots, ignoreMaxHomes));
    }

    public final void deleteHome(@NotNull User owner, @NotNull String name) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().deleteHome(owner, name));
    }

    public final void deleteHome(@NotNull Home home) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().deleteHome(home));
    }

    public final void renameHome(@NotNull User owner, @NotNull String oldName, @NotNull String newName) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeName(owner, oldName, newName));
    }

    public final void renameHome(@NotNull Home home, @NotNull String newName) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeName(home, newName));
    }

    public final void setHomePrivacy(@NotNull User owner, @NotNull String name, boolean isPublic) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomePrivacy(owner, name, isPublic));
    }

    public final void setHomePrivacy(@NotNull Home home, boolean isPublic) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomePrivacy(home, isPublic));
    }

    public final void setHomeDescription(@NotNull User owner, @NotNull String name, @NotNull String description) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeDescription(owner, name, description));
    }

    public final void setHomeDescription(@NotNull Home home, @NotNull String description) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeDescription(home, description));
    }

    public final void relocateHome(@NotNull User owner, @NotNull String name, @NotNull Position position) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomePosition(owner, name, position));
    }

    public final void relocateHome(@NotNull Home home, @NotNull Position position) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomePosition(home, position));
    }

    public final void setHomeMetaTags(@NotNull User owner, @NotNull String name, @NotNull Map<String, String> tags) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeMetaTags(owner, name, tags));
    }

    public final void setHomeMetaTags(@NotNull Home home, @NotNull Map<String, String> tags) {
        this.plugin.runAsync(() -> this.plugin.getManager().homes().setHomeMetaTags(home, tags));
    }

    public final void editHomeMetaTags(@NotNull User owner, @NotNull String name, @NotNull Consumer<Map<String, String>> tagEditor) {
        this.plugin.runAsync(() -> this.plugin.getDatabase().getHome(owner, name).ifPresent(home -> {
            Map<String, String> tags = home.getMeta().getTags();
            tagEditor.accept(tags);
            this.setHomeMetaTags((Home)home, tags);
        }));
    }

    public final CompletableFuture<List<Warp>> getLocalWarps() {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getLocalWarps(this.plugin));
    }

    public final CompletableFuture<List<Warp>> getWarps() {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getWarps());
    }

    public final CompletableFuture<Optional<Warp>> getWarp(@NotNull String warpName) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getWarp(warpName));
    }

    public final CompletableFuture<Optional<Warp>> getWarp(@NotNull UUID warpUuid) {
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getWarp(warpUuid));
    }

    public final CompletableFuture<Warp> createWarp(@NotNull String name, @NotNull Position position) {
        return this.plugin.supplyAsync(() -> this.plugin.getManager().warps().createWarp(name, position));
    }

    public final void deleteWarp(@NotNull String name) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().deleteWarp(name));
    }

    public final void deleteWarp(@NotNull Warp warp) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().deleteWarp(warp));
    }

    public final void renameWarp(@NotNull String oldName, @NotNull String newName) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpName(oldName, newName));
    }

    public final void renameWarp(@NotNull Warp warp, @NotNull String newName) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpName(warp, newName));
    }

    public final void setWarpDescription(@NotNull String name, @NotNull String description) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpDescription(name, description));
    }

    public final void setWarpDescription(@NotNull Warp warp, @NotNull String description) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpDescription(warp, description));
    }

    public final void relocateWarp(@NotNull String name, @NotNull Position position) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpPosition(name, position));
    }

    public final void relocateWarp(@NotNull Warp warp, @NotNull Position position) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpPosition(warp, position));
    }

    public final void setWarpMetaTags(@NotNull String name, @NotNull Map<String, String> tags) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpMetaTags(name, tags));
    }

    public final void setWarpMetaTags(@NotNull Warp warp, @NotNull Map<String, String> tags) {
        this.plugin.runAsync(() -> this.plugin.getManager().warps().setWarpMetaTags(warp, tags));
    }

    public final void editWarpMetaTag(@NotNull String name, @NotNull Consumer<Map<String, String>> tagEditor) {
        this.plugin.runAsync(() -> this.plugin.getDatabase().getWarp(name).ifPresent(warp -> {
            Map<String, String> tags = warp.getMeta().getTags();
            tagEditor.accept(tags);
            this.setWarpMetaTags((Warp)warp, tags);
        }));
    }

    public final CompletableFuture<Optional<? extends Position>> getSpawn() {
        return this.plugin.supplyAsync(this.plugin::getSpawn);
    }

    public final int getMaxHomeSlots(@NotNull OnlineUser user) {
        return this.plugin.getManager().homes().getMaxHomes(user);
    }

    public final int getFreeHomeSlots(@NotNull OnlineUser user) {
        return this.plugin.getManager().homes().getFreeHomes(user);
    }

    public final int getMaxPublicHomeSlots(@NotNull OnlineUser user) {
        return this.plugin.getManager().homes().getMaxPublicHomes(user);
    }

    @NotNull
    public final TeleportBuilder teleportBuilder(@NotNull OnlineUser teleporter) {
        return this.teleportBuilder().teleporter(teleporter);
    }

    @NotNull
    public final TeleportBuilder teleportBuilder() {
        return Teleport.builder(this.plugin);
    }

    public final void randomlyTeleportPlayer(@NotNull OnlineUser user, boolean timedTeleport, String ... rtpArgs) {
        ((CompletableFuture)this.plugin.getRandomTeleportEngine().getRandomPosition(user.getPosition().getWorld(), rtpArgs).thenAccept(position -> {
            if (position.isEmpty()) {
                throw new IllegalStateException("Random teleport engine returned an empty position");
            }
            TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(user).target((Target)position.get());
            try {
                if (timedTeleport) {
                    builder.toTimedTeleport().execute();
                } else {
                    builder.toTeleport().execute();
                }
            }
            catch (TeleportationException e) {
                e.displayMessage(user, rtpArgs);
            }
        })).exceptionally(e -> {
            throw new IllegalStateException("Random teleport engine threw an exception", (Throwable)e);
        });
    }

    public final void randomlyTeleportPlayer(@NotNull OnlineUser user) {
        this.randomlyTeleportPlayer(user, false, new String[0]);
    }

    public final void setRandomTeleportEngine(@NotNull RandomTeleportEngine randomTeleportEngine) {
        this.plugin.setRandomTeleportEngine(randomTeleportEngine);
    }

    public final Optional<MineDown> getLocale(@NotNull String localeKey, String ... replacements) {
        return this.plugin.getLocales().getLocale(localeKey, replacements);
    }

    public final Optional<String> getRawLocale(@NotNull String localeKey, String ... replacements) {
        return this.plugin.getLocales().getRawLocale(localeKey, replacements);
    }

    static final class NotRegisteredException
    extends IllegalStateException {
        private static final String MESSAGE = "Could not access the HuskHomes API as it has not yet been registered. This could be because:\n1) HuskHomes has failed to enable successfully\n2) Your plugin isn't set to load after HuskHomes has\n   (Check if it set as a (soft)depend in plugin.yml or to load: BEFORE in paper-plugin.yml?)\n3) You are attempting to access HuskHomes on plugin construction/before your plugin has enabled.";

        NotRegisteredException() {
            super(MESSAGE);
        }
    }
}

