/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.config.Spawn;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.event.EventDispatcher;
import net.william278.huskhomes.hook.BlueMapHook;
import net.william278.huskhomes.hook.DynmapHook;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.hook.Pl3xMapHook;
import net.william278.huskhomes.hook.PlanHook;
import net.william278.huskhomes.importer.Importer;
import net.william278.huskhomes.libraries.adventure.key.Key;
import net.william278.huskhomes.libraries.annotaml.Annotaml;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.desertwell.util.ThrowingConsumer;
import net.william278.huskhomes.libraries.desertwell.util.UpdateChecker;
import net.william278.huskhomes.libraries.desertwell.util.Version;
import net.william278.huskhomes.libraries.gson.Gson;
import net.william278.huskhomes.libraries.gson.GsonBuilder;
import net.william278.huskhomes.manager.Manager;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportEngine;
import net.william278.huskhomes.user.ConsoleUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;
import net.william278.huskhomes.util.SafetyResolver;
import net.william278.huskhomes.util.Task;
import net.william278.huskhomes.util.TransactionResolver;
import net.william278.huskhomes.util.UnsafeBlocks;
import net.william278.huskhomes.util.Validator;

public interface HuskHomes
extends Task.Supplier,
EventDispatcher,
SafetyResolver,
TransactionResolver {
    public static final int SPIGOT_RESOURCE_ID = 83767;

    @NotNull
    public ConsoleUser getConsole();

    @NotNull
    public List<OnlineUser> getOnlineUsers();

    default public Optional<OnlineUser> getOnlineUser(@NotNull String playerName) {
        return this.getOnlineUserExact(playerName).or(() -> this.getOnlineUsers().stream().filter(user -> user.getUsername().toLowerCase().startsWith(playerName.toLowerCase())).findFirst());
    }

    default public Optional<OnlineUser> getOnlineUserExact(@NotNull String playerName) {
        return this.getOnlineUsers().stream().filter(user -> user.getUsername().equalsIgnoreCase(playerName)).findFirst();
    }

    @NotNull
    public Set<SavedUser> getSavedUsers();

    default public Optional<SavedUser> getSavedUser(@NotNull User user) {
        return this.getSavedUsers().stream().filter(savedUser -> savedUser.getUser().equals(user)).findFirst();
    }

    default public void editUserData(@NotNull User user, @NotNull Consumer<SavedUser> editor) {
        this.runAsync(() -> this.getSavedUser(user).ifPresent(result -> {
            editor.accept((SavedUser)result);
            this.getDatabase().updateUserData((SavedUser)result);
        }));
    }

    default public void initialize(@NotNull String name, @NotNull ThrowingConsumer<HuskHomes> runner) {
        this.log(Level.INFO, "Initializing " + name + "...", new Throwable[0]);
        try {
            runner.accept(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize " + name, e);
        }
        this.log(Level.INFO, "Successfully initialized " + name, new Throwable[0]);
    }

    @NotNull
    public Settings getSettings();

    public void setSettings(@NotNull Settings var1);

    @NotNull
    public Locales getLocales();

    public void setLocales(@NotNull Locales var1);

    public Optional<Spawn> getServerSpawn();

    public void setServerSpawn(@NotNull Spawn var1);

    public void setServerSpawn(@NotNull Location var1);

    default public Optional<Position> getSpawn() {
        return this.getSettings().doCrossServer() && this.getSettings().isGlobalSpawn() ? this.getDatabase().getWarp(this.getSettings().getGlobalSpawnName()).map(warp -> warp) : this.getServerSpawn().map(spawn -> spawn.getPosition(this.getServerName()));
    }

    @NotNull
    public String getServerName();

    public void setServer(@NotNull Server var1);

    public void setUnsafeBlocks(@NotNull UnsafeBlocks var1);

    @NotNull
    public UnsafeBlocks getUnsafeBlocks();

    @NotNull
    public Database getDatabase();

    @NotNull
    public Validator getValidator();

    @NotNull
    public Manager getManager();

    @NotNull
    public Broker getMessenger();

    @NotNull
    public RandomTeleportEngine getRandomTeleportEngine();

    public void setRandomTeleportEngine(@NotNull RandomTeleportEngine var1);

    @NotNull
    public List<Hook> getHooks();

    public void setHooks(@NotNull List<Hook> var1);

    default public <T extends Hook> Optional<T> getHook(@NotNull Class<T> hookClass) {
        return this.getHooks().stream().filter(hook -> hookClass.isAssignableFrom(hook.getClass())).map(hookClass::cast).findFirst();
    }

    default public Optional<MapHook> getMapHook() {
        return this.getHook(MapHook.class);
    }

    @NotNull
    default public List<Importer> getImporters() {
        return this.getHooks().stream().filter(hook -> Importer.class.isAssignableFrom(hook.getClass())).map(Importer.class::cast).collect(Collectors.toList());
    }

    @Nullable
    public InputStream getResource(@NotNull String var1);

    @NotNull
    public File getDataFolder();

    @NotNull
    public List<World> getWorlds();

    @NotNull
    public Version getVersion();

    @NotNull
    public List<Command> getCommands();

    default public <T extends Command> Optional<T> getCommand(@NotNull Class<T> type) {
        return this.getCommands().stream().filter(command -> command.getClass() == type).findFirst().map(type::cast);
    }

    default public void registerHooks() {
        this.setHooks(new ArrayList<Hook>());
        if (this.getSettings().doMapHook()) {
            if (this.isDependencyLoaded("Dynmap")) {
                this.getHooks().add(new DynmapHook(this));
            } else if (this.isDependencyLoaded("BlueMap")) {
                this.getHooks().add(new BlueMapHook(this));
            } else if (this.isDependencyLoaded("Pl3xMap")) {
                this.getHooks().add(new Pl3xMapHook(this));
            }
        }
        if (this.isDependencyLoaded("Plan")) {
            this.getHooks().add(new PlanHook(this));
        }
    }

    default public void registerImporters() {
    }

    public boolean isDependencyLoaded(@NotNull String var1);

    @NotNull
    public Map<String, List<String>> getGlobalPlayerList();

    default public List<String> getPlayerList(boolean includeVanished) {
        return Stream.concat(this.getGlobalPlayerList().values().stream().flatMap(Collection::stream), this.getLocalPlayerList(includeVanished).stream()).distinct().sorted().toList();
    }

    @NotNull
    default public List<String> getPlayerList() {
        return this.getPlayerList(true);
    }

    default public void setPlayerList(@NotNull String server, @NotNull List<String> players) {
        this.getGlobalPlayerList().values().forEach(list -> {
            list.removeAll(players);
            list.removeAll(this.getLocalPlayerList());
        });
        this.getGlobalPlayerList().put(server, players);
    }

    @NotNull
    default public List<String> getLocalPlayerList(boolean includeVanished) {
        return this.getOnlineUsers().stream().filter(user -> includeVanished || !user.isVanished()).map(User::getUsername).toList();
    }

    default public List<String> getLocalPlayerList() {
        return this.getLocalPlayerList(true);
    }

    @NotNull
    public Set<UUID> getCurrentlyOnWarmup();

    default public boolean isWarmingUp(@NotNull UUID userUuid) {
        return this.getCurrentlyOnWarmup().contains(userUuid);
    }

    default public boolean loadConfigs() {
        try {
            this.setSettings((Settings)((Object)Annotaml.create(new File(this.getDataFolder(), "config.yml"), Settings.class).get()));
            Locales languagePresets = Annotaml.create(Locales.class, Objects.requireNonNull(this.getResource("locales/" + this.getSettings().getLanguage() + ".yml"))).get();
            this.setLocales(Annotaml.create(new File(this.getDataFolder(), "messages_" + this.getSettings().getLanguage() + ".yml"), languagePresets).get());
            if (this.getSettings().doCrossServer()) {
                this.setServer((Server)((Object)Annotaml.create(new File(this.getDataFolder(), "server.yml"), Server.class).get()));
            } else {
                this.setServer(new Server(Server.getDefaultServerName()));
            }
            File spawnFile = new File(this.getDataFolder(), "spawn.yml");
            if (spawnFile.exists()) {
                this.setServerSpawn((Spawn)((Object)Annotaml.create(spawnFile, Spawn.class).get()));
            }
            InputStream blocksResource = this.getResource("safety/unsafe_blocks.yml");
            this.setUnsafeBlocks(Annotaml.create(new UnsafeBlocks(), Objects.requireNonNull(blocksResource)).get());
            return true;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.log(Level.SEVERE, "Failed to reload HuskHomes config or messages file", e);
            return false;
        }
    }

    @NotNull
    default public UpdateChecker getUpdateChecker() {
        return UpdateChecker.builder().currentVersion(this.getVersion()).endpoint(UpdateChecker.Endpoint.SPIGOT).resource(Integer.toString(83767)).build();
    }

    default public void checkForUpdates() {
        if (this.getSettings().doCheckForUpdates()) {
            this.getUpdateChecker().check().thenAccept(checked -> {
                if (!checked.isUpToDate()) {
                    this.log(Level.WARNING, "A new version of HuskHomes is available: v" + checked.getLatestVersion() + " (running v" + this.getVersion() + ")", new Throwable[0]);
                }
            });
        }
    }

    public void registerMetrics(int var1);

    public void initializePluginChannels();

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);

    @NotNull
    default public Key getKey(String ... data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Cannot create a key with no data");
        }
        String joined = String.join((CharSequence)"/", data);
        return Key.key("huskhomes", joined);
    }

    @NotNull
    default public Gson getGson() {
        return new GsonBuilder().create();
    }
}

