/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.api.HuskHomesAPI;
import net.william278.huskhomes.command.BukkitCommand;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.config.Locales;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.config.Spawn;
import net.william278.huskhomes.database.Database;
import net.william278.huskhomes.database.H2Database;
import net.william278.huskhomes.database.MySqlDatabase;
import net.william278.huskhomes.database.SqLiteDatabase;
import net.william278.huskhomes.event.BukkitEventDispatcher;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.PlaceholderAPIHook;
import net.william278.huskhomes.hook.VaultEconomyHook;
import net.william278.huskhomes.importer.EssentialsXImporter;
import net.william278.huskhomes.libraries.adventure.platform.bukkit.BukkitAudiences;
import net.william278.huskhomes.libraries.annotaml.Annotaml;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.annotations.TestOnly;
import net.william278.huskhomes.libraries.bstats.bukkit.Metrics;
import net.william278.huskhomes.libraries.bstats.charts.SimplePie;
import net.william278.huskhomes.libraries.desertwell.util.Version;
import net.william278.huskhomes.libraries.paperlib.MorePaperLib;
import net.william278.huskhomes.libraries.paperlib.commands.CommandRegistration;
import net.william278.huskhomes.libraries.paperlib.scheduling.GracefulScheduling;
import net.william278.huskhomes.listener.BukkitEventListener;
import net.william278.huskhomes.listener.EventListener;
import net.william278.huskhomes.manager.Manager;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.network.RedisBroker;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.NormalDistributionEngine;
import net.william278.huskhomes.random.RandomTeleportEngine;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.ConsoleUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.util.BukkitAdapter;
import net.william278.huskhomes.util.BukkitSafetyResolver;
import net.william278.huskhomes.util.BukkitTask;
import net.william278.huskhomes.util.UnsafeBlocks;
import net.william278.huskhomes.util.Validator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitHuskHomes
extends JavaPlugin
implements HuskHomes,
BukkitTask.Supplier,
BukkitEventDispatcher,
PluginMessageListener,
BukkitSafetyResolver {
    private static final int METRICS_ID = 8430;
    private Set<SavedUser> savedUsers;
    private Settings settings;
    private Locales locales;
    private Database database;
    private Validator validator;
    private Manager manager;
    private EventListener eventListener;
    private RandomTeleportEngine randomTeleportEngine;
    private Spawn serverSpawn;
    private UnsafeBlocks unsafeBlocks;
    private List<Hook> hooks;
    private List<Command> commands;
    private Map<String, List<String>> globalPlayerList;
    private Set<UUID> currentlyOnWarmup;
    private Server server;
    private BukkitAudiences audiences;
    private MorePaperLib paperLib;
    @Nullable
    private Broker broker;

    public BukkitHuskHomes() {
    }

    @TestOnly
    protected BukkitHuskHomes(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
    }

    public void onEnable() {
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.paperLib = new MorePaperLib((Plugin)this);
        this.savedUsers = new HashSet<SavedUser>();
        this.globalPlayerList = new HashMap<String, List<String>>();
        this.currentlyOnWarmup = new HashSet<UUID>();
        this.validator = new Validator(this);
        this.initialize("plugin config & locale files", plugin -> {
            if (!this.loadConfigs()) {
                throw new IllegalStateException("Failed to load config files. Please check the console for errors");
            }
        });
        this.initialize(this.getSettings().getDatabaseType().getDisplayName() + " database connection", plugin -> {
            this.database = switch (this.getSettings().getDatabaseType()) {
                default -> throw new IncompatibleClassChangeError();
                case Database.Type.MYSQL, Database.Type.MARIADB -> new MySqlDatabase(this);
                case Database.Type.SQLITE -> new SqLiteDatabase(this);
                case Database.Type.H2 -> new H2Database(this);
            };
            this.database.initialize();
        });
        this.manager = new Manager(this);
        if (this.getSettings().doCrossServer()) {
            this.initialize(this.settings.getBrokerType().getDisplayName() + " message broker", plugin -> {
                this.broker = switch (this.settings.getBrokerType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Broker.Type.PLUGIN_MESSAGE -> new PluginMessageBroker(this);
                    case Broker.Type.REDIS -> new RedisBroker(this);
                };
                this.broker.initialize();
            });
        }
        this.setRandomTeleportEngine(new NormalDistributionEngine(this));
        this.initialize("hooks", plugin -> {
            this.registerHooks();
            if (!this.hooks.isEmpty()) {
                this.hooks.forEach(hook -> {
                    try {
                        hook.initialize();
                    }
                    catch (Throwable e) {
                        this.log(Level.WARNING, "Failed to initialize " + hook.getName() + " hook", e);
                    }
                });
                this.log(Level.INFO, "Registered " + this.hooks.size() + " plugin hooks: " + this.hooks.stream().map(Hook::getName).collect(Collectors.joining(", ")), new Throwable[0]);
            }
        });
        this.initialize("events", plugin -> {
            this.eventListener = this.getListener().register(this);
        });
        this.initialize("commands", plugin -> {
            this.commands = BukkitCommand.Type.getCommands(this);
        });
        this.initialize("API", plugin -> HuskHomesAPI.register(this));
        this.initialize("metrics", plugin -> this.registerMetrics(8430));
        this.checkForUpdates();
    }

    @NotNull
    protected BukkitEventListener getListener() {
        return new BukkitEventListener(this);
    }

    @Override
    public void registerHooks() {
        HuskHomes.super.registerHooks();
        if (this.getSettings().doEconomy() && this.isDependencyLoaded("Vault")) {
            this.getHooks().add(new VaultEconomyHook(this));
        }
        if (this.isDependencyLoaded("PlaceholderAPI")) {
            this.getHooks().add(new PlaceholderAPIHook(this));
        }
    }

    @Override
    public void registerImporters() {
        HuskHomes.super.registerImporters();
        if (this.isDependencyLoaded("Essentials")) {
            this.getHooks().add(new EssentialsXImporter(this));
        }
    }

    @Override
    public boolean isDependencyLoaded(@NotNull String name) {
        return Bukkit.getPluginManager().getPlugin(name) != null;
    }

    public void onDisable() {
        if (this.eventListener != null) {
            this.eventListener.handlePluginDisable();
        }
        if (this.database != null) {
            this.database.terminate();
        }
        if (this.broker != null) {
            this.broker.close();
        }
        if (this.audiences != null) {
            this.audiences.close();
            this.audiences = null;
        }
        this.cancelTasks();
    }

    @Override
    @NotNull
    public ConsoleUser getConsole() {
        return new ConsoleUser(this.audiences.console());
    }

    @Override
    @NotNull
    public List<OnlineUser> getOnlineUsers() {
        return Bukkit.getOnlinePlayers().stream().map(player -> BukkitUser.adapt(player, this)).toList();
    }

    @Override
    @NotNull
    public Set<SavedUser> getSavedUsers() {
        return this.savedUsers;
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(@NotNull Locales locales) {
        this.locales = locales;
    }

    @Override
    @NotNull
    public Database getDatabase() {
        return this.database;
    }

    @Override
    @NotNull
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    @NotNull
    public Manager getManager() {
        return this.manager;
    }

    @Override
    @NotNull
    public Broker getMessenger() {
        if (this.broker == null) {
            throw new IllegalStateException("Attempted to access message broker when it was not initialized");
        }
        return this.broker;
    }

    @Override
    @NotNull
    public RandomTeleportEngine getRandomTeleportEngine() {
        return this.randomTeleportEngine;
    }

    @Override
    public void setRandomTeleportEngine(@NotNull RandomTeleportEngine randomTeleportEngine) {
        this.randomTeleportEngine = randomTeleportEngine;
    }

    @Override
    public Optional<Spawn> getServerSpawn() {
        return Optional.ofNullable(this.serverSpawn);
    }

    @Override
    public void setServerSpawn(@NotNull Spawn spawn) {
        this.serverSpawn = spawn;
    }

    @Override
    public void setServerSpawn(@NotNull Location location) {
        try {
            File spawnFile = new File(this.getDataFolder(), "spawn.yml");
            if (spawnFile.exists() && !spawnFile.delete()) {
                this.log(Level.WARNING, "Failed to delete the existing spawn.yml file", new Throwable[0]);
            }
            this.serverSpawn = Annotaml.create(spawnFile, new Spawn(location)).get();
            BukkitAdapter.adaptLocation(location).ifPresent(bukkitLocation -> {
                assert (bukkitLocation.getWorld() != null) : "World was null when setting server spawn";
                bukkitLocation.getWorld().setSpawnLocation(bukkitLocation);
            });
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.log(Level.WARNING, "Failed to save the server spawn.yml file", e);
        }
    }

    @Override
    @NotNull
    public List<Hook> getHooks() {
        return this.hooks;
    }

    @Override
    public void setHooks(@NotNull List<Hook> hooks) {
        this.hooks = hooks;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString(this.getDescription().getVersion(), "-");
    }

    @Override
    @NotNull
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getGlobalPlayerList() {
        return this.globalPlayerList;
    }

    @Override
    @NotNull
    public Set<UUID> getCurrentlyOnWarmup() {
        return this.currentlyOnWarmup;
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.server.getName();
    }

    @Override
    public void setServer(@NotNull Server server) {
        this.server = server;
    }

    @Override
    public void setUnsafeBlocks(@NotNull UnsafeBlocks unsafeBlocks) {
        this.unsafeBlocks = unsafeBlocks;
    }

    @Override
    @NotNull
    public UnsafeBlocks getUnsafeBlocks() {
        return this.unsafeBlocks;
    }

    @Override
    @NotNull
    public List<World> getWorlds() {
        return this.getServer().getWorlds().stream().filter(world -> BukkitAdapter.adaptWorld(world).isPresent()).map(world -> BukkitAdapter.adaptWorld(world).orElse(null)).toList();
    }

    @Override
    public void registerMetrics(int metricsId) {
        if (!this.getVersion().getMetadata().isBlank()) {
            return;
        }
        try {
            Metrics metrics = new Metrics(this, metricsId);
            metrics.addCustomChart(new SimplePie("bungee_mode", () -> Boolean.toString(this.getSettings().doCrossServer())));
            if (this.getSettings().doCrossServer()) {
                metrics.addCustomChart(new SimplePie("messenger_type", () -> this.getSettings().getBrokerType().getDisplayName()));
            }
            metrics.addCustomChart(new SimplePie("language", () -> this.getSettings().getLanguage().toLowerCase()));
            metrics.addCustomChart(new SimplePie("database_type", () -> this.getSettings().getDatabaseType().getDisplayName()));
            metrics.addCustomChart(new SimplePie("using_economy", () -> Boolean.toString(this.getSettings().doEconomy())));
            metrics.addCustomChart(new SimplePie("using_map", () -> Boolean.toString(this.getSettings().doMapHook())));
            this.getMapHook().ifPresent(hook -> metrics.addCustomChart(new SimplePie("map_type", hook::getName)));
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Failed to register bStats metrics (" + e.getMessage() + ")", new Throwable[0]);
        }
    }

    @Override
    public void initializePluginChannels() {
        String channelId = "BungeeCord";
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        Broker broker;
        if (this.broker != null && (broker = this.broker) instanceof PluginMessageBroker) {
            PluginMessageBroker pluginMessenger = (PluginMessageBroker)broker;
            if (this.getSettings().getBrokerType() == Broker.Type.PLUGIN_MESSAGE) {
                pluginMessenger.onReceive(channel, BukkitUser.adapt(player, this), message);
            }
        }
    }

    @NotNull
    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    @NotNull
    public GracefulScheduling getScheduler() {
        return this.paperLib.scheduling();
    }

    @NotNull
    public CommandRegistration getCommandRegistrar() {
        return this.paperLib.commandRegistration();
    }

    @Override
    @NotNull
    public HuskHomes getPlugin() {
        return this;
    }
}

